/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaClusterBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape UNDERRIPE_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape NORMAL_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Type type;

    public BananaClusterBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return this.type == Type.BARELY_RIPE;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BananaClusterBlock.canClusterGrow((Level)level, pos) && random.m_188503_(5) == 0) {
            this.growBarelyCluster(level, pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.type == Type.BARELY_RIPE;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(6) == 0;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBarelyCluster(level, pos);
    }

    private void growBarelyCluster(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)FOTBlocks.RIPE_BANANA_CLUSTER.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_)), 3);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        if (this.type == Type.UNDERRIPE) {
            return false;
        }
        return adjacentState.m_60713_((Block)this) && direction.m_122434_().m_122478_();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.type.block().get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.type == Type.UNDERRIPE ? UNDERRIPE_SHAPE : NORMAL_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public static boolean canClusterGrow(Level level, BlockPos blockPos) {
        return !level.m_46471_() && BananaClusterBlock.isDaySeeSky(level, blockPos);
    }

    public static boolean canClusterPlantGrow(Level level, BlockPos blockPos) {
        return level.m_46471_() && BananaClusterBlock.isDaySeeSky(level, blockPos);
    }

    private static boolean isDaySeeSky(Level level, BlockPos blockPos) {
        return level.m_46461_() && level.m_45527_(blockPos);
    }

    public static enum Type {
        UNDERRIPE(() -> FOTBlocks.UNDERRIPE_BANANA_CLUSTER),
        BARELY_RIPE(() -> FOTBlocks.BARELY_RIPE_BANANA_CLUSTER),
        RIPE(() -> FOTBlocks.RIPE_BANANA_CLUSTER);

        private final Supplier<Block> block;

        private Type(Supplier<Block> block) {
            this.block = block;
        }

        public Supplier<Block> block() {
            return this.block;
        }
    }
}

