/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.AbstractBananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaClusterPlantBlock
extends AbstractBananaClusterBlock
implements BonemealableBlock {
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.NORTH, Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0), Direction.SOUTH, Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0), Direction.EAST, Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0));
    public static final EnumProperty<HangingType> HANGING = EnumProperty.m_61587_((String)"hanging", HangingType.class);
    private final BananaClusterBlock.Type type;

    public BananaClusterPlantBlock(BananaClusterBlock.Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HANGING, (Comparable)((Object)HangingType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public boolean m_6724_(BlockState state) {
        return this.type != BananaClusterBlock.Type.RIPE;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE && BananaClusterBlock.canClusterPlantGrow((Level)level, pos) && random.m_188503_(10) == 0) {
            level.m_7731_(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.m_152465_(state), 3);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return state.m_60713_(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(6) == 0;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE) {
            level.m_7731_(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.m_152465_(state), 3);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.type.block().get());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && neighborState.m_204336_(FOTTags.Blocks.BANANA_CLUSTER_PLANTS)) {
            if (!neighborState.m_60713_(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && state.m_61143_(HANGING) == HangingType.SMALL_CLUSTER) {
                return (BlockState)state.m_61124_(HANGING, (Comparable)((Object)HangingType.NONE));
            }
            return state.m_61143_(HANGING) == HangingType.STEM || state.m_61143_(HANGING) == HangingType.SMALL_CLUSTER ? state : (BlockState)state.m_61124_(HANGING, (Comparable)((Object)HangingType.NONE));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.m_204336_(FOTTags.Blocks.BANANA_CLUSTER_PLANTS) && !adjacentState.m_60713_(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && direction.m_122434_().m_122478_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HANGING, WATERLOGGED});
    }

    public static enum HangingType implements StringRepresentable
    {
        NONE,
        SMALL_CLUSTER,
        STEM;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

