/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.VerticalLeavesBlock;
import com.stevekung.fishofthieves.client.AngledLeavesComponent;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.CauldronUtils;
import com.stevekung.fishofthieves.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BananaLeavesBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final IntegerProperty COUNT = IntegerProperty.m_61631_((String)"count", (int)1, (int)2);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    public BananaLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.STEM))).m_61124_(TYPE, (Comparable)((Object)Type.LOWER))).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)COUNT) < 2;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)COUNT) < 2) {
            if (state.m_61143_(PART) == Part.STEM) {
                BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
                level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
            } else {
                BlockPos blockPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
                level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_46758_(pos.m_7494_()) && state.m_61143_(PART) == Part.TAIL && random.m_188501_() < 0.2f) {
            CauldronUtils.fillCauldronFromLeavesTail(state, level, pos);
        }
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, TYPE, WATERLOGGED, COUNT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(TYPE) == Type.UPPER ? TOP_AABB : BOTTOM_AABB;
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.TAIL ? direction.m_122424_() : direction;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.m_46758_(pos.m_7494_()) && random.m_188503_(4) == 0) {
            if (state.m_61143_(PART) == Part.STEM) {
                double ySpawn = state.m_61143_(TYPE) == Type.UPPER ? 0.6 : 0.1;
                BlockPos blockPos = pos.m_7495_();
                BlockState blockState = level.m_8055_(blockPos);
                if (!blockState.m_60815_() || !blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP)) {
                    double x = (double)pos.m_123341_() + random.m_188500_();
                    double y = (double)pos.m_123342_() + ySpawn;
                    double z = (double)pos.m_123343_() + random.m_188500_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
                }
            } else {
                Direction direction = (Direction)state.m_61143_((Property)f_54117_);
                double yOffset = state.m_61143_(TYPE) == Type.UPPER ? 0.1 : -0.4;
                AngledLeavesComponent component = new AngledLeavesComponent(22.5, 0.85, 60.0);
                ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.m_146622_((int)2, (int)6), yOffset, 4, false, true, component);
            }
        }
    }

    private BlockState placeVerticalLeaves(Direction direction, boolean isWater) {
        BlockState blockState = (BlockState)FOTBlocks.VERTICAL_BANANA_LEAVES.m_49966_().m_61124_((Property)VerticalLeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        return direction == Direction.DOWN ? (BlockState)blockState.m_61124_((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(true)) : blockState;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)COUNT) < 2 || super.m_6864_(state, useContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos1;
        BlockPos blockPos;
        Level level = context.m_43725_();
        FluidState fluidState = level.m_6425_(blockPos = context.m_8083_());
        boolean isWater = fluidState.m_76152_() == Fluids.f_76193_;
        BlockState blockState2 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)Type.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        Direction direction = context.m_43719_();
        BlockState blockState = level.m_8055_(context.m_8083_());
        if (direction.m_122434_() == Direction.Axis.Y) {
            if (!blockState.m_60713_((Block)this)) {
                return this.placeVerticalLeaves(direction, isWater);
            }
            if (blockState.m_61143_(PART) == Part.TAIL) {
                BlockPos blockPos12 = blockPos.m_121945_(((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_());
                level.m_7731_(blockPos12, (BlockState)level.m_8055_(blockPos12).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.m_61143_((Property)COUNT) + 1))), 2);
            }
            return (BlockState)blockState.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.m_61143_((Property)COUNT) + 1)));
        }
        if (blockState.m_60713_((Block)this)) {
            if (blockState.m_61143_(PART) == Part.TAIL) {
                BlockPos blockPos13 = blockPos.m_121945_(((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_());
                level.m_7731_(blockPos13, (BlockState)level.m_8055_(blockPos13).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.m_61143_((Property)COUNT) + 1))), 2);
            }
            return (BlockState)blockState.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockState.m_61143_((Property)COUNT) + 1)));
        }
        if ((blockState2 = (BlockState)blockState2.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)level, blockPos) && level.m_45752_(blockState2, blockPos1 = blockPos.m_121945_((Direction)blockState2.m_61143_((Property)f_54117_)), CollisionContext.m_82749_()) && level.m_8055_(blockPos1).m_60629_(context) && level.m_6857_().m_61937_(blockPos1)) {
            return context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5 ? (BlockState)blockState2.m_61124_(TYPE, (Comparable)((Object)Type.UPPER)) : blockState2;
        }
        return null;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        Part part;
        if (!level.m_5776_() && player.m_7500_() && (part = (Part)((Object)state.m_61143_(PART))) == Part.TAIL && (blockState = level.m_8055_(blockPos = pos.m_121945_(BananaLeavesBlock.getNeighbourDirection(part, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_(PART) == Part.STEM) {
            level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
            level.m_46961_(blockPos, false);
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState otherState = level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()));
        if (otherState.m_60713_((Block)this) && otherState.m_61143_(PART) == Part.STEM) {
            return state.m_61143_((Property)f_54117_) == otherState.m_61143_((Property)f_54117_);
        }
        return otherState.m_204336_(BlockTags.f_13035_) && otherState.m_60838_((BlockGetter)level, pos) || otherState.m_204336_(FOTTags.Blocks.BANANA_STEMS) || otherState.m_60783_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)f_54117_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_()) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            FluidState fluidState = level.m_6425_(blockPos);
            if (state.m_60713_((Block)this) && state.m_61143_(PART) != Part.TAIL) {
                level.m_7731_(blockPos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TAIL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_)), 3);
            }
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_61143_(PART) == Part.STEM) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            BlockState blockState = level.m_8055_(blockPos);
            return blockState.m_60713_((Block)this) && blockState.m_61143_(PART) == Part.TAIL ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static enum Part implements StringRepresentable
    {
        STEM("stem"),
        TAIL("tail");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Type implements StringRepresentable
    {
        UPPER("upper"),
        LOWER("lower");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

