/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallPomegranatePlantBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    private static final VoxelShape LOWER_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape UPPER_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TallPomegranatePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)PERSISTENT) == false && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && (Integer)state.m_61143_((Property)AGE) <= 2;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AGE, PERSISTENT}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = super.m_5573_(context);
        boolean isUnobstructed = UPPER_SHAPE.m_83281_() || this.isUnobstructed(level, blockPos);
        return blockState != null && isUnobstructed ? blockState : null;
    }

    private boolean isUnobstructed(Level level, BlockPos pos) {
        return level.m_5450_(null, UPPER_SHAPE.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) && level.m_5450_(null, UPPER_SHAPE.m_83216_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_()));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && level.m_46469_().m_46207_(GameRules.f_46132_)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed = CropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos);
        if (random.m_188503_((int)(25.0f / growthSpeed) + 1) == 0) {
            this.grow(level, state, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean canHarvest;
        ItemStack itemStack = player.m_21120_(hand);
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean bl = canHarvest = age == 3;
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && itemStack.m_150930_(Items.f_42574_)) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                    level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                } else {
                    level.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                }
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!canHarvest && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (canHarvest) {
            int count = 1 + level.f_46441_.m_188503_(2);
            TallPomegranatePlantBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FOTItems.POMEGRANATE, count + 1));
            level.m_5594_(null, pos, FOTSoundEvents.POMEGRANATE_PLANT_PICK, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            level.m_7731_(pos, blockState, 2);
            if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                level.m_7731_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else {
                level.m_7731_(pos.m_7495_(), (BlockState)blockState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER), 2);
            }
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos) {
        int i = Math.min((Integer)state.m_61143_((Property)AGE) + 1, 3);
        Boolean persistent = (Boolean)state.m_61143_((Property)PERSISTENT);
        if (this.canGrow((LevelReader)level, pos, state)) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_((Property)PERSISTENT, (Comparable)persistent), 2);
            level.m_7731_(pos.m_7494_(), TallPomegranatePlantBlock.m_182453_((LevelReader)level, (BlockPos)pos.m_7494_(), (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_((Property)PERSISTENT, (Comparable)persistent))), 3);
        }
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.m_60713_(FOTBlocks.TALL_POMEGRANATE_PLANT) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) <= 2 && TallPomegranatePlantBlock.sufficientLight(reader, pos);
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (TallPomegranatePlantBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = level.m_8055_(blockPos);
        return TallPomegranatePlantBlock.isLower(blockState) ? new PosAndState(blockPos, blockState) : null;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos, posAndState.state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state, posAndState.pos);
        }
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

