/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalLeavesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty CEILING = BooleanProperty.m_61465_((String)"ceiling");

    public VerticalLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CEILING, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return VerticalLeavesBlock.canVerticalLeavesSurvive(state, level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public static boolean canVerticalLeavesSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = VerticalLeavesBlock.getConnectedDirection(state).m_122424_();
        BlockState otherState = level.m_8055_(pos.m_121945_(direction));
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_()) || otherState.m_204336_(BlockTags.f_13035_) && otherState.m_60838_((BlockGetter)level, pos);
    }

    private static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)CEILING) != false ? Direction.DOWN : Direction.UP;
    }
}

