/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.frog.Tadpole;

public class HeadphoneModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("headphone"), "main");
    private final ModelPart headphone;

    public HeadphoneModel(ModelPart part) {
        this.headphone = part.m_171324_("headphone");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("headphone", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(1.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).m_171514_(0, 3).m_171481_(-2.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).m_171514_(0, 0).m_171481_(-2.0f, -9.5f, -0.5f, 4.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.headphone.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static interface Scaleable<T extends Entity> {
        public static final Scaleable<Cod> COD = (entity, poseStack) -> poseStack.m_252880_(0.0f, 0.25f, -0.05f);
        public static final Scaleable<Salmon> SALMON = (entity, poseStack) -> {
            poseStack.m_85841_(1.5f, 1.5f, 1.5f);
            poseStack.m_252880_(0.0f, -0.275f, 0.0f);
        };
        public static final Scaleable<Pufferfish> PUFFERFISH = (entity, poseStack) -> {
            float y = 0.0f;
            switch (entity.m_29631_()) {
                case 0: {
                    y = 0.25f;
                    poseStack.m_85841_(1.25f, 1.0f, 0.75f);
                    break;
                }
                case 1: {
                    y = -0.275f;
                    poseStack.m_85841_(1.75f, 1.5f, 1.5f);
                    break;
                }
                case 2: {
                    y = -0.55f;
                    poseStack.m_85841_(3.0f, 2.0f, 2.0f);
                }
            }
            poseStack.m_252880_(0.0f, y, -0.025f);
        };
        public static final Scaleable<TropicalFish> TROPICAL_FISH = (entity, poseStack) -> {
            TropicalFish.Base baseVariant = entity.m_28554_().m_262371_();
            float y = 0.0f;
            float z = 0.0f;
            if (baseVariant == TropicalFish.Base.SMALL) {
                y = 0.275f;
                z = -0.08f;
            } else {
                y = -0.325f;
                z = -0.1f;
                poseStack.m_85841_(1.0f, 1.5f, 1.0f);
            }
            poseStack.m_252880_(0.0f, y, z);
        };
        public static final Scaleable<Tadpole> TADPOLE = (entity, poseStack) -> {
            poseStack.m_85841_(1.1f, 1.1f, 1.1f);
            poseStack.m_252880_(0.0f, 0.15f, -0.08f);
        };

        public void scale(T var1, PoseStack var2);
    }
}

