/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.ModelPartGetter;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.AbstractFish;

public abstract class ThievesFishRenderer<V extends FishData, T extends AbstractFish, M extends EntityModel<T> & HeadphoneModel.Scaleable<T>>
extends MobRenderer<T, M> {
    protected ThievesFishRenderer(EntityRendererProvider.Context context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.m_115326_(new GlowFishLayer(this));
        this.m_115326_(new HeadphoneLayer((LivingEntityRenderer<?, ?>)this, context.m_174027_(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void render(T livingEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = ((ThievesFish)livingEntity).isTrophy() ? 0.25f : 0.15f;
        super.m_7392_(livingEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        boolean inWater = entity.m_20069_() || ((ThievesFish)entity).isNoFlip();
        RotationRenderData rotationRenderData = this.setupRotations(entity, inWater);
        float degree = rotationRenderData.baseDegree * Mth.m_14031_((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * ageInTicks));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        }
        this.doFishPitchYaw(entity, partialTicks);
    }

    public ResourceLocation getTextureLocation(T livingEntity) {
        return ((ThievesFish)livingEntity).getVariant().getTexture();
    }

    protected void scale(T livingEntity, PoseStack poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.m_85841_(scale, scale, scale);
    }

    private void doFishPitchYaw(T entity, float partialTicks) {
        float headPitch = Mth.m_14179_((float)partialTicks, (float)((AbstractFish)entity).f_19860_, (float)entity.m_146909_());
        if (!((AbstractFish)entity).f_19812_) {
            ((ModelPartGetter)this.m_7200_()).main().f_104203_ = headPitch * ((float)Math.PI / 180);
        }
    }

    public abstract RotationRenderData setupRotations(T var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

