/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.behavior.CreateFishFlock;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.entity.ai.behavior.FollowFlockLeader;
import com.stevekung.fishofthieves.entity.ai.behavior.MergeOtherFlock;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class AbstractSchoolingThievesFishAi {
    private static final UniformInt TIME_BETWEEN_BREACH = UniformInt.m_146622_((int)900, (int)1600);

    public static void initMemories(AbstractSchoolingThievesFish<?> fish) {
        fish.m_6274_().m_21879_(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)1);
        fish.m_6274_().m_21879_(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(fish.m_217043_()));
        fish.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_BREACH.m_214085_(fish.m_217043_()));
    }

    public static void resetMemories(AbstractSchoolingThievesFish<?> fish) {
        AbstractSchoolingThievesFishAi.initMemories(fish);
        fish.m_6274_().m_21936_(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
        fish.m_6274_().m_21936_(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER);
        fish.m_6274_().m_21936_(FOTMemoryModuleTypes.FLOCK_LEADER);
        fish.m_6274_().m_21936_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK);
    }

    public static Brain<?> makeBrain(Brain<AbstractSchoolingThievesFish<?>> brain) {
        AbstractSchoolingThievesFishAi.initCoreActivity(brain);
        AbstractSchoolingThievesFishAi.initIdleActivity(brain);
        AbstractSchoolingThievesFishAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void updateActivity(AbstractSchoolingThievesFish<?> fish) {
        fish.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static <T extends AbstractSchoolingThievesFish<?>> void customServerAiStep(T fish, Brain<T> brain) {
        String name = BuiltInRegistries.f_256780_.m_7981_((Object)fish.m_6095_()).m_135815_();
        fish.m_9236_().m_46473_().m_6180_(name + "Brain");
        brain.m_21865_((ServerLevel)fish.m_9236_(), fish);
        fish.m_9236_().m_46473_().m_6182_(name + "ActivityUpdate");
        AbstractSchoolingThievesFishAi.updateActivity(fish);
        fish.m_9236_().m_46473_().m_7238_();
    }

    private static void initCoreActivity(Brain<AbstractSchoolingThievesFish<?>> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), AbstractThievesFishAi.avoidPlayer(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<AbstractSchoolingThievesFish<?>> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of((Object)((Object)new CreateFishFlock()), (Object)2), (Object)Pair.of((Object)((Object)new FollowFlockLeader(1.25f)), (Object)3), (Object)Pair.of(new FishBreaching(TIME_BETWEEN_BREACH, 0.3f, 0.16f), (Object)2)))), (Object)Pair.of((Object)2, (Object)((Object)new MergeOtherFlock())), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20072_), (Object)5))))));
    }

    private static void initRetreatActivity(Brain<AbstractSchoolingThievesFish<?>> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)5.0f, (int)12, (boolean)true), AbstractSchoolingThievesFishAi.createIdleLookBehaviors(), AbstractSchoolingThievesFishAi.createIdleMovementBehaviors(), (Object)EraseMemoryIf.m_258093_(AbstractThievesFishAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    private static RunOne<AbstractSchoolingThievesFish<?>> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)6.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<AbstractSchoolingThievesFish<?>> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)1.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void wasHurtBy(AbstractSchoolingThievesFish<?> fish) {
        Brain brain = fish.m_6274_();
        if (fish.m_27540_()) {
            fish.getLeader().removeFollower();
            brain.m_21879_(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(fish.m_217043_(), 1200));
            brain.m_21936_(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER);
            brain.m_21936_(FOTMemoryModuleTypes.FLOCK_LEADER);
        }
    }
}

