/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTMobEffects;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public class AbstractThievesFishAi {
    public static final UniformInt TIME_BETWEEN_BREACH = UniformInt.m_146622_((int)1200, (int)2000);

    public static Brain<?> makeBrain(Brain<AbstractThievesFish<?>> brain) {
        AbstractThievesFishAi.initCoreActivity(brain);
        AbstractThievesFishAi.initIdleActivity(brain);
        AbstractThievesFishAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initMemories(AbstractThievesFish<?> fish) {
        fish.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_BREACH.m_214085_(fish.m_217043_()));
    }

    public static void updateActivity(AbstractThievesFish<?> fish) {
        fish.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static Ingredient getCommonTemptations() {
        return ThievesFish.WORMS;
    }

    public static Ingredient getLeechesTemptations() {
        return ThievesFish.LEECHES_FOOD;
    }

    public static Ingredient getEarthwormsTemptations() {
        return ThievesFish.EARTHWORMS_FOOD;
    }

    public static Ingredient getGrubsTemptations() {
        return ThievesFish.GRUBS_FOOD;
    }

    public static <T extends AbstractThievesFish<?>> void customServerAiStep(T fish, Brain<T> brain) {
        String name = BuiltInRegistries.f_256780_.m_7981_((Object)fish.m_6095_()).m_135815_();
        fish.m_9236_().m_46473_().m_6180_(name + "Brain");
        brain.m_21865_((ServerLevel)fish.m_9236_(), fish);
        fish.m_9236_().m_46473_().m_6182_(name + "ActivityUpdate");
        AbstractThievesFishAi.updateActivity(fish);
        fish.m_9236_().m_46473_().m_7238_();
    }

    private static void initCoreActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), AbstractThievesFishAi.avoidPlayer(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of(new FishBreaching(TIME_BETWEEN_BREACH, 0.3f, 0.16f), (Object)2)))), (Object)Pair.of((Object)2, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20072_), (Object)5))))));
    }

    private static void initRetreatActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)5.0f, (int)12, (boolean)true), AbstractThievesFishAi.createIdleLookBehaviors(), AbstractThievesFishAi.createIdleMovementBehaviors(), (Object)EraseMemoryIf.m_258093_(AbstractThievesFishAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    private static RunOne<AbstractThievesFish<?>> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)6.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<AbstractThievesFish<?>> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)1.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)5.0f, (int)10, (boolean)true);
    }

    public static <T extends AbstractFish> boolean isPosNearNearestRepellent(T fish, BlockPos pos) {
        Optional optional = fish.m_6274_().m_21952_(MemoryModuleType.f_26356_);
        return optional.isPresent() && ((BlockPos)optional.get()).m_123314_((Vec3i)pos, 10.0);
    }

    public static BehaviorControl<LivingEntity> avoidPlayer() {
        return CopyMemoryWithExpiry.m_257819_(AbstractThievesFishAi::isNearPlayerNotCrouching, (MemoryModuleType)MemoryModuleType.f_26368_, (MemoryModuleType)MemoryModuleType.f_26383_, (UniformInt)TimeUtil.m_145020_((int)5, (int)7));
    }

    public static <T extends AbstractFish> boolean wantsToStopFleeing(T fish) {
        Brain brain = fish.m_6274_();
        if (!brain.m_21874_(MemoryModuleType.f_26383_)) {
            return true;
        }
        LivingEntity livingEntity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26383_).get();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return !brain.m_21938_(MemoryModuleType.f_26368_, (Object)player);
        }
        return false;
    }

    public static <T extends LivingEntity> boolean isNearPlayerNotCrouching(T fish) {
        Brain brain = fish.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26368_)) {
            Player player = (Player)brain.m_21952_(MemoryModuleType.f_26368_).get();
            return !player.m_6047_() && !player.m_21023_(FOTMobEffects.GUARDIAN_STIFLE) && fish.m_19950_((Entity)player, 6.0);
        }
        return false;
    }
}

