/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.behavior.CreateFishFlock;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.entity.ai.behavior.FollowFlockLeader;
import com.stevekung.fishofthieves.entity.ai.behavior.StartAttackingIgnoreFlockLeader;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class BattlegillAi {
    public static Brain<?> makeBrain(Brain<Battlegill> brain) {
        BattlegillAi.initCoreActivity(brain);
        BattlegillAi.initIdleActivity(brain);
        BattlegillAi.initFightActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void updateActivity(Battlegill fish) {
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            fish.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        } else {
            fish.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37979_));
        }
    }

    public static void initMemories(Battlegill fish) {
        fish.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)AbstractThievesFishAi.TIME_BETWEEN_BREACH.m_214085_(fish.m_217043_()));
    }

    private static void initCoreActivity(Brain<Battlegill> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<Battlegill> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of((Object)((Object)new CreateFishFlock()), (Object)2), (Object)Pair.of((Object)((Object)new FollowFlockLeader(1.25f)), (Object)3), (Object)Pair.of(new FishBreaching(AbstractThievesFishAi.TIME_BETWEEN_BREACH, 0.2f, 0.12f), (Object)4)))), (Object)Pair.of((Object)2, new StartAttackingIgnoreFlockLeader<Battlegill>(BattlegillAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20072_), (Object)5))))));
    }

    private static void initFightActivity(Brain<Battlegill> brain) {
        brain.m_21895_(Activity.f_37988_, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257811_(livingEntity -> false, (mob, livingEntity) -> livingEntity.m_6274_().m_21879_(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(livingEntity.m_217043_(), 200)), (boolean)true), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.25f), (Object)MeleeAttack.m_257733_((int)20)), MemoryModuleType.f_26372_);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Battlegill fish) {
        return fish.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }
}

