/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class FishBreaching<E extends LivingEntity>
extends Behavior<E> {
    private static final int[] STEPS_TO_CHECK = new int[]{1, 2, 3};
    private final float jumpVelocity;
    private final float horizontalVelocity;
    private final UniformInt chance;

    public FishBreaching(UniformInt chance, float jumpVelocity, float horizontalVelocity) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.BREACHED_TICK, (Object)MemoryStatus.REGISTERED));
        this.jumpVelocity = jumpVelocity;
        this.horizontalVelocity = horizontalVelocity;
        this.chance = chance;
    }

    protected boolean m_6114_(ServerLevel level, E owner) {
        int[] nArray;
        int n;
        int n2;
        Direction direction = owner.m_6374_();
        int stepX = direction.m_122429_();
        int stepZ = direction.m_122431_();
        BlockPos blockPos = owner.m_20183_();
        boolean inWater = owner.m_20069_();
        if (!inWater) {
            owner.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)this.chance.m_214085_(level.f_46441_));
        }
        if ((n2 = 0) < (n = (nArray = STEPS_TO_CHECK).length)) {
            int scale = nArray[n2];
            boolean isClear = !this.waterIsClear(owner, blockPos, stepX, stepZ, scale) || !this.surfaceIsClear(owner, blockPos, stepX, stepZ, scale);
            return inWater && !isClear;
        }
        return false;
    }

    protected void m_6735_(ServerLevel level, E entity, long gameTime) {
        Direction direction = entity.m_6374_();
        entity.m_216990_(FOTSoundEvents.FISH_JUMP);
        entity.m_20256_(entity.m_20184_().m_82520_((double)((float)direction.m_122429_() * this.horizontalVelocity), (double)this.jumpVelocity, (double)((float)direction.m_122431_() * this.horizontalVelocity)));
        entity.m_6274_().m_21879_(FOTMemoryModuleTypes.BREACHED_TICK, (Object)20);
    }

    protected void m_6732_(ServerLevel level, E entity, long gameTime) {
        entity.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)this.chance.m_214085_(level.f_46441_));
    }

    protected void m_6725_(ServerLevel level, E owner, long gameTime) {
        Vec3 vec3 = owner.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && owner.m_146909_() != 0.0f) {
            owner.m_146926_(Mth.m_14189_((float)0.2f, (float)owner.m_146909_(), (float)0.0f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d = vec3.m_165924_();
            double e = Math.atan2(-vec3.f_82480_, d) * 180.0 / 3.1415927410125732;
            owner.m_146926_((float)e);
        }
    }

    private boolean waterIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        blockPos = blockPos.m_7918_(dx * scale, 0, dz * scale);
        return entity.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && !entity.m_9236_().m_8055_(blockPos).m_280555_();
    }

    private boolean surfaceIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        return entity.m_9236_().m_8055_(blockPos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && entity.m_9236_().m_8055_(blockPos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }
}

