/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MergeOtherFlock
extends Behavior<AbstractSchoolingThievesFish> {
    private static final Predicate<AbstractSchoolingThievesFish> NOT_MERGE_FROM_OTHER_FLOCK = follower -> !follower.m_6274_().m_21874_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK);
    private static final Predicate<AbstractSchoolingThievesFish> IS_FLOCK_LEADER = AbstractSchoolingThievesFish::isLeader;

    public MergeOtherFlock() {
        super((Map)ImmutableMap.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER, (Object)MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)MemoryStatus.REGISTERED, FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, AbstractSchoolingThievesFish owner) {
        Optional<AbstractSchoolingThievesFish> nearestLeaderOptional = this.getNearestLeader(owner);
        if (nearestLeaderOptional.isPresent()) {
            AbstractSchoolingThievesFish nearestLeader = nearestLeaderOptional.get();
            if (!owner.isTrophy() && nearestLeader.isTrophy()) {
                return false;
            }
            if (!owner.isTrophy() && !nearestLeader.isTrophy()) {
                return true;
            }
        }
        return true;
    }

    protected void start(ServerLevel level, AbstractSchoolingThievesFish owner, long gameTime) {
        Brain brain = owner.m_6274_();
        boolean mergedFromOtherFlock = brain.m_21874_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK) && (Boolean)brain.m_21952_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK).get() != false;
        Optional<AbstractSchoolingThievesFish> nearestLeaderOptional = this.getNearestLeader(owner);
        if (owner.isLeader() && !mergedFromOtherFlock && nearestLeaderOptional.isPresent()) {
            AbstractSchoolingThievesFish nearestLeader = nearestLeaderOptional.get();
            Integer thisSchoolSize = (Integer)brain.m_21952_(FOTMemoryModuleTypes.SCHOOL_SIZE).get();
            Integer otherSchoolSize = (Integer)nearestLeader.m_6274_().m_21952_(FOTMemoryModuleTypes.SCHOOL_SIZE).get();
            int combinedSchoolSize = thisSchoolSize + otherSchoolSize;
            if (combinedSchoolSize <= owner.m_6031_()) {
                Optional flockFollowersFromOtherLeader = nearestLeader.m_6274_().m_21952_(FOTMemoryModuleTypes.FLOCK_FOLLOWERS);
                flockFollowersFromOtherLeader.ifPresent(list -> list.stream().filter(NOT_MERGE_FROM_OTHER_FLOCK).forEach(follower -> {
                    follower.m_6274_().m_21879_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, (Object)true);
                    follower.m_6274_().m_21879_(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)owner);
                    owner.addFollower();
                    ((List)brain.m_21952_(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get()).add(follower);
                }));
                nearestLeader.m_6274_().m_21879_(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)1);
                nearestLeader.m_6274_().m_21879_(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)owner);
                nearestLeader.m_6274_().m_21879_(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, (Object)true);
                nearestLeader.m_6274_().m_21879_(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, (Object)true);
                owner.addFollower();
                ((List)brain.m_21952_(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get()).add(nearestLeader);
                nearestLeader.m_6274_().m_21936_(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
            }
        }
    }

    private Optional<AbstractSchoolingThievesFish> getNearestLeader(AbstractSchoolingThievesFish owner) {
        Brain brain = owner.m_6274_();
        Optional optional = brain.m_21952_(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER);
        return ((List)optional.get()).stream().filter(fish -> fish != owner).filter(owner::isSameType).filter(IS_FLOCK_LEADER.and(arg_0 -> ((AbstractSchoolingThievesFish)owner).m_142582_(arg_0)).and(NOT_MERGE_FROM_OTHER_FLOCK)).findAny();
    }
}

