/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.DevilfishAi;
import com.stevekung.fishofthieves.entity.variant.DevilfishVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.DevilfishVariants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class Devilfish
extends AbstractSchoolingThievesFish<DevilfishVariant> {
    private static final EntityDataAccessor<DevilfishVariant> VARIANT = SynchedEntityData.m_135353_(Devilfish.class, FOTDataSerializers.DEVILFISH_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.m_137469_((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:ashen", (Object)0);
        map.put((Object)"fishofthieves:seashell", (Object)1);
        map.put((Object)"fishofthieves:lava", (Object)2);
        map.put((Object)"fishofthieves:forsaken", (Object)3);
        map.put((Object)"fishofthieves:firelight", (Object)4);
    });
    private static final ImmutableList<SensorType<? extends Sensor<? super Devilfish>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, (Object)SensorType.f_26814_, FOTSensorTypes.NEAREST_SCHOOLING_THIEVES_FISH, FOTSensorTypes.GRUBS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.DEVILFISH_ATTACKABLES);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26356_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, FOTMemoryModuleTypes.SCHOOL_SIZE, FOTMemoryModuleTypes.FLOCK_LEADER, (Object[])new MemoryModuleType[]{FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_148199_, FOTMemoryModuleTypes.BREACHED_TICK});

    public Devilfish(EntityType<? extends Devilfish> entityType, Level level) {
        super(entityType, level);
    }

    protected Brain.Provider<Devilfish> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return DevilfishAi.makeBrain((Brain<Devilfish>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Devilfish> m_6274_() {
        return super.m_6274_();
    }

    @Override
    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("devilfishBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_6182_("devilfishActivityUpdate");
        DevilfishAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public double m_142593_(LivingEntity entity) {
        return 1.0 + (double)entity.m_20205_() * 2.0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)DevilfishVariants.ASHEN);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        DevilfishAi.initMemories(this);
    }

    @Override
    public Registry<DevilfishVariant> getRegistry() {
        return FOTRegistry.DEVILFISH_VARIANT;
    }

    @Override
    public void setVariant(DevilfishVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public DevilfishVariant getVariant() {
        return (DevilfishVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<DevilfishVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_DEVILFISH_SPAWNS, DevilfishVariants.ASHEN, fromBucket);
    }

    @Override
    public BiMap<String, Integer> variantToCustomModelData() {
        return VARIANT_TO_INT;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.DEVILFISH_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.DEVILFISH_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.DEVILFISH_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.DEVILFISH_FLOP;
    }

    public int m_6031_() {
        return 4;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.275f, (float)0.275f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.375f : 0.18f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return GRUBS_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        return isWater && blockPos.m_123342_() <= 0 && !level.m_204166_(blockPos).m_203656_(FOTTags.Biomes.DEVILFISH_CANNOT_SPAWN);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.01);
    }
}

