/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.WildsplashVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WildsplashVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class Wildsplash
extends AbstractSchoolingThievesFish<WildsplashVariant> {
    private static final EntityDataAccessor<WildsplashVariant> VARIANT = SynchedEntityData.m_135353_(Wildsplash.class, FOTDataSerializers.WILDSPLASH_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.m_137469_((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:russet", (Object)0);
        map.put((Object)"fishofthieves:sandy", (Object)1);
        map.put((Object)"fishofthieves:ocean", (Object)2);
        map.put((Object)"fishofthieves:muddy", (Object)3);
        map.put((Object)"fishofthieves:coral", (Object)4);
    });

    public Wildsplash(EntityType<? extends Wildsplash> entityType, Level level) {
        super(entityType, level);
    }

    protected Brain.Provider<AbstractSchoolingThievesFish<?>> m_5490_() {
        return Brain.m_21923_((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return AbstractSchoolingThievesFishAi.makeBrain(this.m_5490_().m_22073_(dynamic));
    }

    public Brain<AbstractSchoolingThievesFish<?>> m_6274_() {
        return super.m_6274_();
    }

    @Override
    protected void m_8024_() {
        AbstractSchoolingThievesFishAi.customServerAiStep(this, this.m_6274_());
        super.m_8024_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)WildsplashVariants.RUSSET);
    }

    @Override
    public Registry<WildsplashVariant> getRegistry() {
        return FOTRegistry.WILDSPLASH_VARIANT;
    }

    @Override
    public void setVariant(WildsplashVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public WildsplashVariant getVariant() {
        return (WildsplashVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<WildsplashVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_WILDSPLASH_SPAWNS, WildsplashVariants.RUSSET, fromBucket);
    }

    @Override
    public BiMap<String, Integer> variantToCustomModelData() {
        return VARIANT_TO_INT;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.WILDSPLASH_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.WILDSPLASH_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.WILDSPLASH_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.WILDSPLASH_FLOP;
    }

    public int m_6031_() {
        return 4;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.3f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.38f : 0.2f;
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return EARTHWORMS_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isSurfaceWater = WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random);
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        Holder biome = level.m_204166_(blockPos);
        return isWater && biome.m_203656_(FOTTags.Biomes.SPAWNS_WILDSPLASH) || isSurfaceWater;
    }
}

