/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BananaLeavesPlacer
extends FoliagePlacer {
    public static final Codec<BananaLeavesPlacer> CODEC = RecordCodecBuilder.create(instance -> BananaLeavesPlacer.frondsPart(instance).apply((Applicative)instance, BananaLeavesPlacer::new));
    protected final float oneLeavesChance;

    protected static <P extends BananaLeavesPlacer> Products.P1<RecordCodecBuilder.Mu<P>, Float> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("one_leaves_chance").forGetter(placer -> Float.valueOf(placer.oneLeavesChance)));
    }

    public BananaLeavesPlacer(float oneLeavesChance) {
        super((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0));
        this.oneLeavesChance = oneLeavesChance;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return FOTFoliagePlacerTypes.BANANA_LEAVES_PLACER;
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.m_161451_();
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            for (int localY = offset; localY >= offset - 1; --localY) {
                if (localY == 0) {
                    BlockState blockState = FOTBlocks.VERTICAL_BANANA_LEAVES.m_49966_();
                    if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
                    }
                    blockSetter.m_271838_(pos, blockState);
                    continue;
                }
                BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2 = direction.m_122424_();
                    BlockPos blockPos2 = mutableBlockPos.m_7918_(direction2.m_122429_(), localY, direction2.m_122431_());
                    BlockState blockState = (BlockState)((BlockState)((BlockState)config.f_161213_.m_213972_(random, pos).m_61124_((Property)BananaLeavesBlock.f_54117_, (Comparable)direction2)).m_61124_((Property)BananaLeavesBlock.COUNT, (Comparable)Integer.valueOf(random.m_188501_() < this.oneLeavesChance ? 1 : 2))).m_61124_(BananaLeavesBlock.TYPE, (Comparable)((Object)BananaLeavesBlock.Type.UPPER));
                    if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
                    }
                    if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos2)) continue;
                    blockSetter.m_271838_(blockPos2, blockState);
                    blockSetter.m_271838_(blockPos2.m_5484_(direction2, 1), (BlockState)blockState.m_61124_(BananaLeavesBlock.PART, (Comparable)((Object)BananaLeavesBlock.Part.TAIL)));
                }
            }
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.m_188503_(2) == 0 || localY == 0);
    }
}

