/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.CoconutFrondsBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CoconutFrondsPlacer
extends FoliagePlacer {
    public static final Codec<CoconutFrondsPlacer> CODEC = RecordCodecBuilder.create(instance -> CoconutFrondsPlacer.frondsPart(instance).apply((Applicative)instance, CoconutFrondsPlacer::new));
    protected final int height;
    protected final int maxLeavesLengthFromLocalY;
    protected final List<Pair<Integer, Integer>> reduceLeavesLength;

    protected static <P extends CoconutFrondsPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Integer, Integer, List<Pair<Integer, Integer>>> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.intRange((int)0, (int)8).fieldOf("height").forGetter(placer -> placer.height)).and((App)Codec.intRange((int)0, (int)8).fieldOf("max_leaves_length_from_local_y").forGetter(placer -> placer.maxLeavesLengthFromLocalY)).and((App)Codec.mapPair((MapCodec)Codec.intRange((int)0, (int)16).fieldOf("at_tree_height"), (MapCodec)Codec.intRange((int)0, (int)8).fieldOf("reduce_by")).codec().listOf().fieldOf("reduce_leaves_length").forGetter(placer -> placer.reduceLeavesLength));
    }

    public CoconutFrondsPlacer(int height, int maxLeavesLengthFromLocalY, List<Pair<Integer, Integer>> reduceLeavesLength) {
        super((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0));
        this.height = height;
        this.maxLeavesLengthFromLocalY = maxLeavesLengthFromLocalY;
        this.reduceLeavesLength = reduceLeavesLength;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return FOTFoliagePlacerTypes.COCONUT_FRONDS_PLACER;
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.m_161451_();
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            for (int localY = offset; localY >= offset - foliageHeight; --localY) {
                if (localY == 0) {
                    BlockState blockState = FOTBlocks.VERTICAL_COCONUT_FRONDS.m_49966_();
                    if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
                    }
                    blockSetter.m_271838_(pos, blockState);
                    continue;
                }
                BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
                int maxLeavesFromLocalYLength = this.maxLeavesLengthFromLocalY - localY;
                for (Pair<Integer, Integer> reduceLeavesLength : this.reduceLeavesLength) {
                    if (maxFreeTreeHeight != (Integer)reduceLeavesLength.getFirst()) continue;
                    maxLeavesFromLocalYLength -= ((Integer)reduceLeavesLength.getSecond()).intValue();
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2 = direction.m_122424_();
                    BlockPos blockPos2 = mutableBlockPos.m_7918_(direction2.m_122429_(), localY, direction2.m_122431_());
                    boolean isPositiveDir = direction2.m_122421_() == Direction.AxisDirection.POSITIVE;
                    BlockState blockState = (BlockState)config.f_161213_.m_213972_(random, pos).m_61124_((Property)CoconutFrondsBlock.f_54117_, (Comparable)direction2);
                    if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
                    }
                    if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos2)) {
                        blockSetter.m_271838_(blockPos2, blockState);
                    }
                    block7: for (int leavesLength = 0; leavesLength < maxLeavesFromLocalYLength; ++leavesLength) {
                        blockState = leavesLength == maxLeavesFromLocalYLength - 1 ? (BlockState)blockState.m_61124_(CoconutFrondsBlock.PART, (Comparable)((Object)CoconutFrondsBlock.Part.TAIL)) : (BlockState)blockState.m_61124_(CoconutFrondsBlock.PART, (Comparable)((Object)CoconutFrondsBlock.Part.MIDDLE));
                        switch (direction.m_122434_()) {
                            case X: {
                                int x;
                                int n = x = isPositiveDir ? direction2.m_122429_() + leavesLength : direction2.m_122429_() - leavesLength;
                                if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos2.m_7918_(x, 0, 0))) continue block7;
                                blockSetter.m_271838_(blockPos2.m_7918_(x, 0, 0), blockState);
                                continue block7;
                            }
                            case Z: {
                                int z;
                                int n = z = isPositiveDir ? direction2.m_122431_() + leavesLength : direction2.m_122431_() - leavesLength;
                                if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos2.m_7918_(0, 0, z))) continue block7;
                                blockSetter.m_271838_(blockPos2.m_7918_(0, 0, z), blockState);
                            }
                        }
                    }
                }
            }
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.m_188503_(2) == 0 || localY == 0);
    }
}

