/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.level;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTFeatures;
import com.stevekung.fishofthieves.registry.FOTPlacements;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class FOTBiomeModifiers {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, FOTFeatures::bootstrap).m_254916_(Registries.f_256988_, FOTPlacements::bootstrap).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
        context.m_255272_(FOTBiomeModifiers.key("add_splashtails"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_SPLASHTAILS, new MobSpawnSettings.SpawnerData(FOTEntities.SPLASHTAIL, FishOfThieves.CONFIG.spawnRate.fishWeight.splashtail, 4, 8)));
        context.m_255272_(FOTBiomeModifiers.key("add_pondies"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_PONDIES, new MobSpawnSettings.SpawnerData(FOTEntities.PONDIE, FishOfThieves.CONFIG.spawnRate.fishWeight.pondie, 2, 4)));
        context.m_255272_(FOTBiomeModifiers.key("add_islehoppers"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_ISLEHOPPERS, new MobSpawnSettings.SpawnerData(FOTEntities.ISLEHOPPER, FishOfThieves.CONFIG.spawnRate.fishWeight.islehopper, 2, 4)));
        context.m_255272_(FOTBiomeModifiers.key("add_ancientscales"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_ANCIENTSCALES, new MobSpawnSettings.SpawnerData(FOTEntities.ANCIENTSCALE, FishOfThieves.CONFIG.spawnRate.fishWeight.ancientscale, 4, 8)));
        context.m_255272_(FOTBiomeModifiers.key("add_plentifins"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_PLENTIFINS, new MobSpawnSettings.SpawnerData(FOTEntities.PLENTIFIN, FishOfThieves.CONFIG.spawnRate.fishWeight.plentifin, 4, 8)));
        context.m_255272_(FOTBiomeModifiers.key("add_wildsplash"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_WILDSPLASH, new MobSpawnSettings.SpawnerData(FOTEntities.WILDSPLASH, FishOfThieves.CONFIG.spawnRate.fishWeight.wildsplash, 2, 4)));
        context.m_255272_(FOTBiomeModifiers.key("add_devilfish"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_DEVILFISH, new MobSpawnSettings.SpawnerData(FOTEntities.DEVILFISH, FishOfThieves.CONFIG.spawnRate.fishWeight.devilfish, 1, 2)));
        context.m_255272_(FOTBiomeModifiers.key("add_battlegills"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_BATTLEGILLS, new MobSpawnSettings.SpawnerData(FOTEntities.BATTLEGILL, FishOfThieves.CONFIG.spawnRate.fishWeight.battlegill, 2, 4)));
        context.m_255272_(FOTBiomeModifiers.key("add_wreckers"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_WRECKERS, new MobSpawnSettings.SpawnerData(FOTEntities.WRECKER, FishOfThieves.CONFIG.spawnRate.fishWeight.wrecker, 4, 8)));
        context.m_255272_(FOTBiomeModifiers.key("add_stormfish"), (Object)FOTBiomeModifiers.spawn((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.SPAWNS_STORMFISH, new MobSpawnSettings.SpawnerData(FOTEntities.STORMFISH, FishOfThieves.CONFIG.spawnRate.fishWeight.stormfish, 4, 8)));
        context.m_255272_(FOTBiomeModifiers.key("add_fish_bone"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, FOTTags.Biomes.HAS_FISH_BONE, FOTPlacements.FISH_BONE, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_coconut_tree"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_48217_, FOTPlacements.TREES_COCONUT, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_sparse_jungle_tropical_flower"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_186769_, FOTPlacements.SPARSE_JUNGLE_TROPICAL_FLOWER, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_sparse_jungle_fruit_trees"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_186769_, FOTPlacements.SPARSE_JUNGLE_FRUIT_TREES, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_sparse_jungle_patch_wild_pineapple"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_186769_, FOTPlacements.SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_sparse_jungle_patch_wild_pomegranate"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_186769_, FOTPlacements.SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(FOTBiomeModifiers.key("add_sparse_jungle_patch_tropical_bush"), (Object)FOTBiomeModifiers.addBiomeFeature((BootstapContext<BiomeModifier>)context, (ResourceKey<Biome>)Biomes.f_186769_, FOTPlacements.SPARSE_JUNGLE_PATCH_TROPICAL_BUSH, GenerationStep.Decoration.VEGETAL_DECORATION));
    });

    public static void generateBiomeModifiers(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new BiomeModifiers(output, event.getLookupProvider()));
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addBiomeFeature(BootstapContext<BiomeModifier> context, TagKey<Biome> biomeTagKey, ResourceKey<PlacedFeature> placedFeatureKey, GenerationStep.Decoration decoration) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomeTagKey), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)}), decoration);
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addBiomeFeature(BootstapContext<BiomeModifier> context, ResourceKey<Biome> biomeKey, ResourceKey<PlacedFeature> placedFeatureKey, GenerationStep.Decoration decoration) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biomeKey)}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)}), decoration);
    }

    private static ResourceKey<BiomeModifier> key(String key) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)FishOfThieves.id(key));
    }

    private static BiomeModifier spawn(BootstapContext<BiomeModifier> context, TagKey<Biome> tagKey, MobSpawnSettings.SpawnerData spawnerData) {
        HolderSet.Named tag = context.m_255420_(Registries.f_256952_).m_254956_(tagKey);
        return ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)tag, (MobSpawnSettings.SpawnerData)spawnerData);
    }

    private static class BiomeModifiers
    extends DatapackBuiltinEntriesProvider {
        public BiomeModifiers(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of("fishofthieves"));
        }

        public String m_6055_() {
            return "Biome Modifier Registries: fishofthieves";
        }
    }
}

