/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.proxy;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.compatibility.terrablender.FOTTerraBlender;
import com.stevekung.fishofthieves.loot.FOTLootManager;
import com.stevekung.fishofthieves.registry.FOTTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

public class CommonProxyForge {
    public void init() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(this::registerAttributes);
        context.getModEventBus().addListener(this::registerSpawnPlacement);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FishOfThieves.initCommon();
            if (FOTPlatform.isModLoaded("terrablender")) {
                FOTTerraBlender.init();
            }
        });
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_204117_(FOTTags.Items.WOODEN_FISH_PLAQUE)) {
            event.setBurnTime(300);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        ResourceLocation id = event.getName();
        FOTLootManager.getInjectedLootTableMap().forEach((resourceKey, function) -> {
            if (id.equals(resourceKey)) {
                CommonProxyForge.injectLoot(table, ((LootPool.Builder)function.apply(LootPool.m_79043_())).f_79067_);
            }
        });
        FOTLootManager.getInjectedLootPoolMap().forEach((resourceKey, function) -> {
            if (id.equals(resourceKey)) {
                table.addPool(((LootPool.Builder)function.apply(LootPool.m_79043_())).m_79082_());
            }
        });
    }

    @SubscribeEvent
    public void registerVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35591_) {
            Int2ObjectMap trades = event.getTrades();
            FishOfThieves.getFishermanTrades().forEach((level, factories) -> ((List)trades.get(level.intValue())).addAll((Collection)factories.apply(Lists.newArrayList())));
        }
    }

    private void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        FishOfThieves.getSpawnPlacements().forEach(entry -> event.register(entry.type(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, entry.spawnPredicate(), SpawnPlacementRegisterEvent.Operation.OR));
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        FishOfThieves.getEntityAttributes().forEach((entityType, builder) -> event.put(entityType, builder.m_22265_()));
    }

    private static void injectLoot(LootTable table, List<LootPoolEntryContainer> entries) {
        LootPool pool = table.getPool("main");
        pool.f_79023_ = (LootPoolEntryContainer[])ArrayUtils.addAll((Object[])pool.f_79023_, (Object[])((LootPoolEntryContainer[])entries.toArray(LootPoolEntryContainer[]::new)));
    }
}

