/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.google.common.collect.BiMap;
import com.stevekung.fishofthieves.FishOfThieves;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FOTItem
extends Item {
    private final EntityType<?> entityType;
    private final BiMap<String, Integer> variantToCustomModelData;

    public FOTItem(Item.Properties properties, EntityType<?> entityType, BiMap<String, Integer> variantToCustomModelData) {
        super(properties);
        this.entityType = entityType;
        this.variantToCustomModelData = variantToCustomModelData;
    }

    public static void addFishVariants(CreativeModeTab.Output output, Item item) {
        output.m_246326_((ItemLike)item);
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            for (int i = 1; i < 5; ++i) {
                output.m_246342_(FOTItem.create(item, i));
            }
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            String variant;
            if (itemStack.m_41782_() && compoundTag.m_128425_("CustomModelData", 3)) {
                int data = compoundTag.m_128451_("CustomModelData");
                variant = (String)this.variantToCustomModelData.inverse().get((Object)data);
            } else {
                variant = (String)this.variantToCustomModelData.inverse().get((Object)0);
            }
            tooltipComponents.add((Component)Component.m_237115_((String)(this.entityType.m_20675_() + "." + ResourceLocation.m_135820_((String)variant).m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    private static ItemStack create(Item item, int index) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41784_().m_128405_("CustomModelData", index);
        return itemStack;
    }
}

