/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.google.common.collect.BiMap;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FOTMobBucketItem
extends MobBucketItem {
    private final EntityType<?> entityType;
    private final BiMap<String, Integer> variantToCustomModelData;

    public FOTMobBucketItem(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, BiMap<String, Integer> variantToCustomModelData, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.entityType = entityType;
        this.variantToCustomModelData = variantToCustomModelData;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (this.entityType.m_204039_(FOTTags.EntityTypes.THIEVES_FISH_ENTITY_TYPE)) {
            if (itemStack.m_41782_()) {
                if (compoundTag.m_128425_("variant", 8)) {
                    MutableComponent type = this.createTooltip(compoundTag.m_128461_("variant"));
                    if (compoundTag.m_128471_("Trophy")) {
                        type.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)"entity.fishofthieves.trophy"));
                    }
                    tooltipComponents.add((Component)type);
                }
            } else if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
                tooltipComponents.add((Component)this.createTooltip((String)this.variantToCustomModelData.keySet().stream().findFirst().get()));
            }
        }
    }

    public static void addFishVariantsBucket(CreativeModeTab.Output output, Item item) {
        output.m_246326_((ItemLike)item);
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            for (int i = 1; i < 5; ++i) {
                output.m_246342_(FOTMobBucketItem.create(item, ((FOTMobBucketItem)item).variantToCustomModelData, i));
            }
        }
    }

    private MutableComponent createTooltip(String location) {
        return Component.m_237115_((String)"entity.fishofthieves.%s.%s".formatted(BuiltInRegistries.f_256780_.m_7981_(this.entityType).m_135815_(), ResourceLocation.m_135820_((String)location).m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    }

    private static ItemStack create(Item item, BiMap<String, Integer> variantToCustomModelData, int index) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128405_("CustomModelData", index);
        compoundTag.m_128359_("variant", (String)variantToCustomModelData.inverse().get((Object)index));
        return itemStack;
    }
}

