/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.animal;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.block.MangoFruitBlock;
import com.stevekung.fishofthieves.block.PineappleCropBlock;
import com.stevekung.fishofthieves.block.PomegranatePlantBlock;
import com.stevekung.fishofthieves.block.TallPomegranatePlantBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Bee.class})
public class MixinBee {

    @Mixin(targets={"net.minecraft.world.entity.animal.Bee$BeePollinateGoal"})
    public static class MixinBeePollinateGoal {
        @Inject(method={"method_21819(Lnet/minecraft/world/level/block/state/BlockState;)Z"}, cancellable=true, at={@At(value="RETURN", ordinal=2)})
        private static void fishofthieves$addCheckForPomegranateFlowering(BlockState blockState, CallbackInfoReturnable<Boolean> info) {
            if (blockState.m_60713_(FOTBlocks.POMEGRANATE_PLANT)) {
                info.setReturnValue((Object)((Integer)blockState.m_61143_((Property)PomegranatePlantBlock.AGE) == 1 ? 1 : 0));
            } else if (blockState.m_60713_(FOTBlocks.TALL_POMEGRANATE_PLANT)) {
                info.setReturnValue((Object)((Integer)blockState.m_61143_((Property)TallPomegranatePlantBlock.AGE) == 1 && blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? 1 : 0));
            } else if (blockState.m_60713_(FOTBlocks.PINEAPPLE_CROP)) {
                info.setReturnValue((Object)((Integer)blockState.m_61143_((Property)PineappleCropBlock.AGE) == 3 && blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER ? 1 : 0));
            }
        }
    }

    @Mixin(targets={"net.minecraft.world.entity.animal.Bee$BeeGrowCropGoal"})
    public static abstract class MixinBeeGrowCropGoal
    extends Goal {
        @Unique
        private Bee bee;

        @Inject(method={"<init>"}, at={@At(value="TAIL")})
        private void fishofthieves$init(Bee bee, CallbackInfo info) {
            this.bee = bee;
        }

        @Inject(method={"tick"}, at={@At(value="JUMP", ordinal=1)})
        private void fishofthieves$addGrowableBlocksInCube(CallbackInfo info) {
            for (BlockPos blockPos : BlockPos.m_235650_((RandomSource)this.bee.m_217043_(), (int)3, (BlockPos)this.bee.m_20183_(), (int)2)) {
                int age;
                BlockState blockState = this.bee.m_9236_().m_8055_(blockPos);
                if (blockState.m_60713_(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) || blockState.m_60713_(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT)) {
                    ((BonemealableBlock)blockState.m_60734_()).m_214148_((ServerLevel)this.bee.m_9236_(), this.bee.m_217043_(), blockPos, blockState);
                    continue;
                }
                if (!blockState.m_60713_(FOTBlocks.MANGO_FRUIT) && !blockState.m_60713_(FOTBlocks.HANGING_MANGO_FRUIT) || (age = ((Integer)blockState.m_61143_((Property)MangoFruitBlock.AGE)).intValue()) >= 2) continue;
                this.bee.m_9236_().m_7731_(blockPos, (BlockState)blockState.m_60734_().m_152465_(blockState).m_61124_((Property)MangoFruitBlock.AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            }
        }

        @Inject(method={"tick"}, at={@At(value="JUMP", ordinal=2)}, slice={@Slice(from=@At(value="FIELD", target="net/minecraft/world/level/block/Blocks.CAVE_VINES:Lnet/minecraft/world/level/block/Block;", shift=At.Shift.AFTER))})
        private void fishofthieves$addGrowableBlocksWithBonemeal(CallbackInfo info, @Local BlockPos blockPos, @Local(ordinal=0) BlockState stateToCheck) {
            if (stateToCheck.m_60713_(FOTBlocks.MANGO_PIT) || stateToCheck.m_60713_(FOTBlocks.PINEAPPLE_CROP) || stateToCheck.m_60713_(FOTBlocks.POMEGRANATE_PLANT) || stateToCheck.m_60713_(FOTBlocks.TALL_POMEGRANATE_PLANT) || stateToCheck.m_60713_(FOTBlocks.POMEGRANATE_SAPLING)) {
                ((BonemealableBlock)stateToCheck.m_60734_()).m_214148_((ServerLevel)this.bee.m_9236_(), this.bee.m_217043_(), blockPos, stateToCheck);
            }
        }
    }
}

