/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.block.HangingMangoFruitBlock;
import com.stevekung.fishofthieves.block.MangoFruitBlock;
import com.stevekung.fishofthieves.block.PineappleCropBlock;
import com.stevekung.fishofthieves.block.PomegranatePlantBlock;
import com.stevekung.fishofthieves.feature.FishBoneFeature;
import com.stevekung.fishofthieves.feature.SimpleAgeBlockFeature;
import com.stevekung.fishofthieves.feature.SingleBlockFeature;
import com.stevekung.fishofthieves.feature.TropicalIslandBlockBlobFeature;
import com.stevekung.fishofthieves.feature.blockpredicates.BlockBrightnessPredicate;
import com.stevekung.fishofthieves.feature.blockpredicates.SeeSkyPredicate;
import com.stevekung.fishofthieves.feature.configurations.SimpleAgeBlockConfiguration;
import com.stevekung.fishofthieves.feature.foliageplacers.BananaLeavesPlacer;
import com.stevekung.fishofthieves.feature.foliageplacers.CoconutFrondsPlacer;
import com.stevekung.fishofthieves.feature.stateproviders.DirectionalRandomizedIntBooleanStateProvider;
import com.stevekung.fishofthieves.feature.stateproviders.RandomizedIntBooleanStateProvider;
import com.stevekung.fishofthieves.feature.treedecorators.BananaDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.BananaShootsDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.CoconutDecorator;
import com.stevekung.fishofthieves.feature.treedecorators.DirectionalAttachedToLeavesDecorator;
import com.stevekung.fishofthieves.feature.trunkplacers.BananaTrunkPlacer;
import com.stevekung.fishofthieves.feature.trunkplacers.CoconutTrunkPlacer;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTPlacements;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class FOTFeatures {
    private static final FishBoneFeature FISH_BONE_FEATURE = new FishBoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    private static final Feature<SimpleAgeBlockConfiguration> SIMPLE_AGE_BLOCK = new SimpleAgeBlockFeature(SimpleAgeBlockConfiguration.CODEC);
    private static final Feature<SimpleBlockConfiguration> SINGLE_BLOCK = new SingleBlockFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_);
    private static final Feature<BlockStateConfiguration> TROPICAL_ISLAND_BLOB = new TropicalIslandBlockBlobFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_);
    public static final ResourceKey<ConfiguredFeature<?, ?>> FISH_BONE = FOTFeatures.createKey("fish_bone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COCONUT_TREE = FOTFeatures.createKey("coconut_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BANANA_TREE = FOTFeatures.createKey("banana_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGO_TREE = FOTFeatures.createKey("mango_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANGO_TREE_BEES_02 = FOTFeatures.createKey("mango_tree_bees_02");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPICAL_FLOWER = FOTFeatures.createKey("tropical_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_TROPICAL_ISLAND = FOTFeatures.createKey("trees_tropical_island");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_PINEAPPLE = FOTFeatures.createKey("wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WILD_PINEAPPLE = FOTFeatures.createKey("tall_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WILD_PINEAPPLE = FOTFeatures.createKey("patch_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TROPICAL_MELON = FOTFeatures.createKey("patch_tropical_melon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_COCONUT = FOTFeatures.createKey("trees_coconut");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_POMEGRANATE = FOTFeatures.createKey("wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WILD_POMEGRANATE = FOTFeatures.createKey("tall_wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WILD_POMEGRANATE = FOTFeatures.createKey("patch_wild_pomegranate");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TROPICAL_BUSH = FOTFeatures.createKey("patch_tropical_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TROPICAL_ISLAND_ROCK = FOTFeatures.createKey("tropical_island_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_FRUIT_TREES = FOTFeatures.createKey("sparse_jungle_fruit_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE = FOTFeatures.createKey("sparse_jungle_patch_wild_pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE = FOTFeatures.createKey("sparse_jungle_patch_wild_pomegranate");

    public static void init() {
        FOTFeatures.register("fish_bone", FISH_BONE_FEATURE);
        FOTFeatures.register("simple_age_block", SIMPLE_AGE_BLOCK);
        FOTFeatures.register("single_block", SINGLE_BLOCK);
        FOTFeatures.register("tropical_island_blob", TROPICAL_ISLAND_BLOB);
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeature = context.m_255420_(Registries.f_256988_);
        FeatureUtils.m_254977_(context, FISH_BONE, (Feature)FISH_BONE_FEATURE, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        FeatureUtils.m_254977_(context, COCONUT_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)FOTFeatures.createCoconutTree().m_68249_((List)ImmutableList.of((Object)((Object)new CoconutDecorator(0.6f, 0.45f, 2)))).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49992_)).m_68244_().m_68251_());
        FeatureUtils.m_254977_(context, BANANA_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)FOTFeatures.createBananaTree().m_68249_((List)ImmutableList.of((Object)((Object)new BananaDecorator(0.4f, 0.2f, 0.4f, 6)), (Object)((Object)new BananaShootsDecorator(0.3f)))).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50493_)).m_68244_().m_68251_());
        FeatureUtils.m_254977_(context, MANGO_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)FOTFeatures.createMangoTree(0.01f).m_68251_());
        FeatureUtils.m_254977_(context, MANGO_TREE_BEES_02, (Feature)Feature.f_65760_, (FeatureConfiguration)FOTFeatures.createMangoTree(0.2f).m_68251_());
        FeatureUtils.m_254977_(context, TREES_TROPICAL_ISLAND, (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.m_255043_(TreePlacements.f_195385_), 0.05f), new WeightedPlacedFeature((Holder)placedFeature.m_255043_(FOTPlacements.MANGO_TREE_CHECKED), 0.1f), new WeightedPlacedFeature((Holder)placedFeature.m_255043_(FOTPlacements.BANANA_TREE_CHECKED), 0.1f)), (Holder)placedFeature.m_255043_(TreePlacements.f_195384_)));
        FeatureUtils.m_254977_(context, TROPICAL_FLOWER, (Feature)Feature.f_65761_, (FeatureConfiguration)FOTFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)FOTBlocks.PINK_PLUMERIA.m_49966_(), 12).m_146271_((Object)FOTBlocks.LIGHT_BLUE_PLUMERIA.m_49966_(), 10).m_146271_((Object)FOTBlocks.WHITE_PLUMERIA.m_49966_(), 8).m_146271_((Object)FOTBlocks.TROPICAL_MONSTERA.m_49966_(), 3).m_146271_((Object)FOTBlocks.TROPICAL_RED_FERN.m_49966_(), 3).m_146271_((Object)FOTBlocks.VERTICAL_BANANA_LEAVES.m_49966_(), 2)), 64));
        FeatureUtils.m_254977_(context, WILD_PINEAPPLE, (Feature)Feature.f_65761_, (FeatureConfiguration)FOTFeatures.wildPineapplePatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.m_49966_().m_61124_((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(0))), 8).m_146271_((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.m_49966_().m_61124_((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(1))), 6).m_146271_((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.m_49966_().m_61124_((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(2))), 4).m_146271_((Object)((BlockState)FOTBlocks.PINEAPPLE_CROP.m_49966_().m_61124_((Property)PineappleCropBlock.AGE, (Comparable)Integer.valueOf(3))), 2)), 16));
        FeatureUtils.m_254977_(context, TALL_WILD_PINEAPPLE, SIMPLE_AGE_BLOCK, (FeatureConfiguration)new SimpleAgeBlockConfiguration(new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)FOTBlocks.PINEAPPLE_CROP.m_49966_()), PineappleCropBlock.AGE, (IntProvider)UniformInt.m_146622_((int)4, (int)5))));
        FeatureUtils.m_254977_(context, PATCH_WILD_PINEAPPLE, (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.m_255043_(FOTPlacements.TALL_WILD_PINEAPPLE), 0.85f)), (Holder)placedFeature.m_255043_(FOTPlacements.WILD_PINEAPPLE)));
        FeatureUtils.m_254977_(context, PATCH_TROPICAL_MELON, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(16, 7, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50186_)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})}))));
        FeatureUtils.m_254977_(context, TREES_COCONUT, (Feature)Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeature.m_255043_(FOTPlacements.COCONUT_TREE_CHECKED)})));
        FeatureUtils.m_254977_(context, WILD_POMEGRANATE, (Feature)Feature.f_65761_, (FeatureConfiguration)FOTFeatures.wildPomegranatePatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.m_49966_().m_61124_((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(0))), 8).m_146271_((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.m_49966_().m_61124_((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(1))), 6).m_146271_((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.m_49966_().m_61124_((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(2))), 4).m_146271_((Object)((BlockState)FOTBlocks.POMEGRANATE_PLANT.m_49966_().m_61124_((Property)PomegranatePlantBlock.AGE, (Comparable)Integer.valueOf(3))), 2)), 16));
        FeatureUtils.m_254977_(context, TALL_WILD_POMEGRANATE, SIMPLE_AGE_BLOCK, (FeatureConfiguration)new SimpleAgeBlockConfiguration(new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)FOTBlocks.TALL_POMEGRANATE_PLANT.m_49966_()), PomegranatePlantBlock.AGE, (IntProvider)UniformInt.m_146622_((int)0, (int)3))));
        FeatureUtils.m_254977_(context, PATCH_WILD_POMEGRANATE, (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeature.m_255043_(FOTPlacements.TALL_WILD_POMEGRANATE), 0.5f)), (Holder)placedFeature.m_255043_(FOTPlacements.WILD_POMEGRANATE)));
        FeatureUtils.m_254977_(context, PATCH_TROPICAL_BUSH, (Feature)Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(32, 4, 2, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)FOTBlocks.TROPICAL_MONSTERA.m_49966_(), 4).m_146271_((Object)FOTBlocks.TROPICAL_RED_FERN.m_49966_(), 2).m_146271_((Object)FOTBlocks.VERTICAL_BANANA_LEAVES.m_49966_(), 1))), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockBrightnessPredicate.value(13)), BlockPredicate.m_190402_((BlockPredicate)SeeSkyPredicate.INSTANCE), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})}))));
        FeatureUtils.m_254977_(context, TROPICAL_ISLAND_ROCK, TROPICAL_ISLAND_BLOB, (FeatureConfiguration)new BlockStateConfiguration(Blocks.f_50069_.m_49966_()));
        FeatureUtils.m_254977_(context, SPARSE_JUNGLE_FRUIT_TREES, (Feature)Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeature.m_255043_(FOTPlacements.MANGO_TREE_CHECKED), placedFeature.m_255043_(FOTPlacements.BANANA_TREE_CHECKED)})));
        FeatureUtils.m_254977_(context, SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE, (Feature)Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeature.m_255043_(FOTPlacements.TALL_WILD_PINEAPPLE), placedFeature.m_255043_(FOTPlacements.WILD_PINEAPPLE)})));
        FeatureUtils.m_254977_(context, SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE, (Feature)Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeature.m_255043_(FOTPlacements.TALL_WILD_POMEGRANATE), placedFeature.m_255043_(FOTPlacements.WILD_POMEGRANATE)})));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createCoconutTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.COCONUT_LOG), (TrunkPlacer)new CoconutTrunkPlacer(7, 2, 2, (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.SMALL_COCONUT_LOG), (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.MEDIUM_COCONUT_LOG), (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.SMALL_TOP_COCONUT_LOG)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.COCONUT_FRONDS), (FoliagePlacer)new CoconutFrondsPlacer(2, 1, List.of(Pair.of((Object)7, (Object)1))), (FeatureSize)new ThreeLayersFeatureSize(5, 15, 1, 2, 4, OptionalInt.empty()));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBananaTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.BANANA_STEM), (TrunkPlacer)new BananaTrunkPlacer(3, 6, (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.BANANA_CLUSTER_GROWABLE_STEM)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.BANANA_LEAVES), (FoliagePlacer)new BananaLeavesPlacer(0.2f), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 1, 2, 5, OptionalInt.empty()));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createMangoTree(float beehiveChance) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new FancyTrunkPlacer(5, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)FOTBlocks.MANGO_LEAVES), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68249_(List.of(new AttachedToLeavesDecorator(0.1f, 2, 0, (BlockStateProvider)new RandomizedIntBooleanStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)FOTBlocks.HANGING_MANGO_FRUIT.m_49966_()), HangingMangoFruitBlock.AGE, (IntProvider)UniformInt.m_146622_((int)0, (int)2), MangoFruitBlock.FALLING, ConstantFloat.m_146458_((float)0.6f)), 2, List.of(Direction.DOWN)), new DirectionalAttachedToLeavesDecorator(0.5f, 1, 1, new DirectionalRandomizedIntBooleanStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)FOTBlocks.MANGO_FRUIT.m_49966_()), MangoFruitBlock.AGE, (IntProvider)UniformInt.m_146622_((int)0, (int)2), MangoFruitBlock.FACING, MangoFruitBlock.FALLING, ConstantFloat.m_146458_((float)0.6f)), 1, Direction.Plane.HORIZONTAL.m_122557_().toList(), true), new BeehiveDecorator(beehiveChance))).m_68244_();
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider blockStateProvider, int tries) {
        return FeatureUtils.m_206470_((int)tries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static RandomPatchConfiguration wildPineapplePatch(BlockStateProvider blockStateProvider, int tries) {
        return new RandomPatchConfiguration(tries, 4, 2, PlacementUtils.m_206495_(SINGLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static RandomPatchConfiguration wildPomegranatePatch(BlockStateProvider blockStateProvider, int tries) {
        return new RandomPatchConfiguration(tries, 5, 3, PlacementUtils.m_206495_(SINGLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider)));
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> void register(String key, F value) {
        FOTPlatform.registerFeature(key, value);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)FishOfThieves.id(name));
    }
}

