/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AncientscaleVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class AncientscaleVariants {
    public static final AncientscaleVariant ALMOND = AncientscaleVariant.builder().condition(SpawnSelectors.always()).texture("almond").build();
    public static final AncientscaleVariant SAPPHIRE = AncientscaleVariant.builder().condition(SpawnSelectors.always()).texture("sapphire").build();
    public static final AncientscaleVariant SMOKE = AncientscaleVariant.builder().condition(SpawnSelectors.always()).texture("smoke").build();
    public static final AncientscaleVariant BONE = AncientscaleVariant.builder().condition(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.variant.boneAncientscaleProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.boneAncientscaleProbability).or(SpawnSelectors.structureTag(FOTTags.Structures.BONE_ANCIENTSCALES_SPAWN_IN).and(context -> context.random().m_188503_(10) == 0)))).texture("bone").build();
    public static final AncientscaleVariant STARSHINE = AncientscaleVariant.builder().condition(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(context -> context.level().m_46940_() <= 0.25f))).texture("starshine").glowTexture("starshine_glow").build();

    public static void init() {
        AncientscaleVariants.register("almond", ALMOND);
        AncientscaleVariants.register("sapphire", SAPPHIRE);
        AncientscaleVariants.register("smoke", SMOKE);
        AncientscaleVariants.register("bone", BONE);
        AncientscaleVariants.register("starshine", STARSHINE);
    }

    private static void register(String key, AncientscaleVariant variant) {
        Registry.m_122965_(FOTRegistry.ANCIENTSCALE_VARIANT, (ResourceLocation)FishOfThieves.id(key), (Object)variant);
    }
}

