/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GuardianFruitTreePiece
extends TemplateStructurePiece {
    private float fruitChance;

    public GuardianFruitTreePiece(StructureTemplateManager structureTemplateManager, BlockPos templatePosition, ResourceLocation location, Rotation rotation, Mirror mirror, BlockPos pivotPos, float fruitChance) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, 0, structureTemplateManager, location, location.toString(), GuardianFruitTreePiece.makeSettings(mirror, rotation, pivotPos), templatePosition);
        this.fruitChance = fruitChance;
    }

    public GuardianFruitTreePiece(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, tag, structureTemplateManager, resourceLocation -> GuardianFruitTreePiece.makeSettings(structureTemplateManager, tag, resourceLocation));
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
        tag.m_128359_("Mirror", this.f_73657_.m_74401_().name());
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager structureTemplateManager, CompoundTag tag, ResourceLocation location) {
        StructureTemplate structureTemplate = structureTemplateManager.m_230359_(location);
        BlockPos blockPos = new BlockPos(structureTemplate.m_163801_().m_123341_() / 2, 0, structureTemplate.m_163801_().m_123343_() / 2);
        return GuardianFruitTreePiece.makeSettings(Mirror.valueOf((String)tag.m_128461_("Mirror")), Rotation.valueOf((String)tag.m_128461_("Rotation")), blockPos);
    }

    private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation, BlockPos pos) {
        BlockIgnoreProcessor blockIgnoreProcessor = BlockIgnoreProcessor.f_74046_;
        ArrayList list = Lists.newArrayList();
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.f_50377_, 0.1f, (BlockState)FOTBlocks.PRISMARIZED_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.f_50377_, 0.1f, (BlockState)FOTBlocks.PRISMARIZED_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.f_50377_, 0.03f, Blocks.f_50450_));
        return new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74385_(pos).m_74383_((StructureProcessor)blockIgnoreProcessor).m_74383_((StructureProcessor)new RuleProcessor((List)list)).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_));
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        BoundingBox boundingBox = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
        if (box.m_71051_((Vec3i)boundingBox.m_162394_())) {
            box.m_162386_(boundingBox);
            super.m_213694_(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadPrismarine(random, (LevelAccessor)level);
            this.addPrismarineDripColumnsBelow(random, (LevelAccessor)level);
        }
    }

    protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        if (name.equals("guardian_fruit_block") && random.m_188501_() <= this.fruitChance) {
            level.m_7731_(pos, FOTBlocks.GUARDIAN_FRUIT.m_49966_(), 2);
        }
    }

    private void addPrismarineDripColumnsBelow(RandomSource random, LevelAccessor level) {
        for (int i = this.f_73383_.m_162395_() + 1; i < this.f_73383_.m_162399_(); ++i) {
            for (int j = this.f_73383_.m_162398_() + 1; j < this.f_73383_.m_162401_(); ++j) {
                BlockPos blockPos = new BlockPos(i, this.f_73383_.m_162396_(), j);
                if (!level.m_8055_(blockPos).m_60713_(Blocks.f_50377_)) continue;
                this.addPrismarineDripColumn(random, level, blockPos.m_7495_());
            }
        }
    }

    private void addPrismarineDripColumn(RandomSource random, LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
        for (int i = 8; i > 0 && random.m_188501_() < 0.5f; --i) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
        }
    }

    private void spreadPrismarine(RandomSource random, LevelAccessor level) {
        BlockPos blockPos = this.f_73383_.m_162394_();
        int i = blockPos.m_123341_();
        int j = blockPos.m_123343_();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = fs.length;
        int l = (this.f_73383_.m_71056_() + this.f_73383_.m_71058_()) / 2;
        int m = random.m_188503_(Math.max(1, 8 - l / 2));
        BlockPos.MutableBlockPos mutableBlockPos = BlockPos.f_121853_.m_122032_();
        for (int o = i - k; o <= i + k; ++o) {
            for (int p = j - k; p <= j + k; ++p) {
                int q = Math.abs(o - i) + Math.abs(p - j);
                int r = Math.max(0, q + m);
                if (r >= k) continue;
                float f = fs[r];
                if (!(random.m_188500_() < (double)f)) continue;
                int s = GuardianFruitTreePiece.getSurfaceY(level, o, p);
                int t = Math.min(this.f_73383_.m_162396_(), s);
                mutableBlockPos.m_122178_(o, t, p);
                if (Math.abs(t - this.f_73383_.m_162396_()) > 3 || !this.canBlockBeReplaced(level, (BlockPos)mutableBlockPos)) continue;
                this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
                this.addPrismarineDripColumn(random, level, mutableBlockPos.m_7495_());
            }
        }
    }

    private boolean canBlockBeReplaced(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return !blockState.m_60713_(Blocks.f_50016_) && !blockState.m_204336_(BlockTags.f_144287_);
    }

    private void placeDecoratedBlocksOrMagma(RandomSource random, LevelAccessor level, BlockPos pos) {
        if (random.m_188501_() < 0.03f) {
            level.m_7731_(pos, Blocks.f_50450_.m_49966_(), 3);
        } else if (random.m_188501_() < 0.1f) {
            level.m_7731_(pos, (BlockState)FOTBlocks.PRISMARIZED_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(random.m_188499_() ? Direction.Axis.X : Direction.Axis.Z)), 3);
        } else {
            level.m_7731_(pos, Blocks.f_50377_.m_49966_(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor level, int x, int z) {
        return level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
    }

    private static ProcessorRule getBlockReplaceRule(Block block, float probability, Block replaceBlock) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(block, probability), (RuleTest)AlwaysTrueTest.f_73954_, replaceBlock.m_49966_());
    }

    private static ProcessorRule getBlockReplaceRule(Block block, float probability, BlockState blockState) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(block, probability), (RuleTest)AlwaysTrueTest.f_73954_, blockState);
    }
}

