/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTStructures;
import com.stevekung.fishofthieves.structure.GuardianFruitTreePiece;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GuardianFruitTreeStructure
extends Structure {
    private static final String[] GUARDIAN_FRUIT_TREES = (String[])IntStream.rangeClosed(1, 5).mapToObj(value -> "guardian_fruit_tree_" + value).toArray(String[]::new);
    public static final Codec<GuardianFruitTreeStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fruit_chance").forGetter(structure -> Float.valueOf(structure.fruitChance)), (App)GuardianFruitTreeStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, GuardianFruitTreeStructure::new));
    private final float fruitChance;

    public GuardianFruitTreeStructure(float fruitChance, Structure.StructureSettings settings) {
        super(settings);
        this.fruitChance = fruitChance;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom worldgenRandom = context.f_226626_();
        ResourceLocation resourceLocation = FishOfThieves.id(GUARDIAN_FRUIT_TREES[worldgenRandom.m_188503_(GUARDIAN_FRUIT_TREES.length)]);
        StructureTemplate structureTemplate = context.f_226625_().m_230359_(resourceLocation);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenRandom);
        Mirror mirror = worldgenRandom.m_188501_() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockPos = new BlockPos(structureTemplate.m_163801_().m_123341_() / 2, 0, structureTemplate.m_163801_().m_123343_() / 2);
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        BlockPos blockPos2 = context.f_226628_().m_45615_();
        BoundingBox boundingBox = structureTemplate.m_74598_(blockPos2, rotation, blockPos, mirror);
        BlockPos blockPos3 = boundingBox.m_162394_();
        int height = chunkGenerator.m_214096_(blockPos3.m_123341_(), blockPos3.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor, randomState) - 1;
        int y = GuardianFruitTreeStructure.findSuitableY(chunkGenerator, height, boundingBox, levelHeightAccessor, randomState);
        BlockPos blockPos4 = new BlockPos(blockPos2.m_123341_(), y, blockPos2.m_123343_());
        return Optional.of(new Structure.GenerationStub(blockPos4, structurePiecesBuilder -> structurePiecesBuilder.m_142679_((StructurePiece)new GuardianFruitTreePiece(context.f_226625_(), blockPos4, resourceLocation, rotation, mirror, blockPos, this.fruitChance))));
    }

    private static int findSuitableY(ChunkGenerator chunkGenerator, int height, BoundingBox box, LevelHeightAccessor level, RandomState randomState) {
        int l;
        int i = level.m_141937_() + 15;
        ImmutableList list = ImmutableList.of((Object)new BlockPos(box.m_162395_(), 0, box.m_162398_()), (Object)new BlockPos(box.m_162399_(), 0, box.m_162398_()), (Object)new BlockPos(box.m_162395_(), 0, box.m_162401_()), (Object)new BlockPos(box.m_162399_(), 0, box.m_162401_()));
        List<NoiseColumn> list2 = list.stream().map(blockPos -> chunkGenerator.m_214184_(blockPos.m_123341_(), blockPos.m_123343_(), level, randomState)).toList();
        for (l = height; l > i; --l) {
            int m = 0;
            for (NoiseColumn noiseColumn : list2) {
                BlockState blockState = noiseColumn.m_183556_(l);
                if (!Heightmap.Types.OCEAN_FLOOR_WG.m_64299_().test(blockState) || ++m != 3) continue;
                return l;
            }
        }
        return l;
    }

    public StructureType<?> m_213658_() {
        return FOTStructures.Type.GUARDIAN_FRUIT_TREE;
    }
}

