/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTStructures;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SeapostPieces {
    private static final ResourceLocation SEAPOST = FishOfThieves.id("seapost");
    private static final ResourceLocation SEAPOST_BASE = FishOfThieves.id("seapost_base");
    private static final Map<ResourceLocation, BlockPos> PIVOTS = ImmutableMap.of((Object)SEAPOST, (Object)new BlockPos(-5, 0, 10), (Object)SEAPOST_BASE, (Object)new BlockPos(-5, 0, 11));
    private static final Map<ResourceLocation, BlockPos> OFFSETS = ImmutableMap.of((Object)SEAPOST, (Object)new BlockPos(0, 8, 0), (Object)SEAPOST_BASE, (Object)BlockPos.f_121853_);
    private static final List<Block> POTTED_BLOCKS = List.of(Blocks.f_50233_, Blocks.f_50232_, Blocks.f_50236_, Blocks.f_50247_, Blocks.f_220847_, Blocks.f_152601_, Blocks.f_152602_, FOTBlocks.POTTED_PINK_PLUMERIA, FOTBlocks.POTTED_WHITE_PLUMERIA, FOTBlocks.POTTED_LIGHT_BLUE_PLUMERIA);

    public static void addPieces(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieces) {
        pieces.m_142679_((StructurePiece)new SeapostPiece(structureTemplateManager, SEAPOST, pos, rotation, 8));
        pieces.m_142679_((StructurePiece)new SeapostPiece(structureTemplateManager, SEAPOST_BASE, pos.m_6625_(1), rotation, 0));
    }

    public static class SeapostPiece
    extends TemplateStructurePiece {
        public SeapostPiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, int offset) {
            super(FOTStructures.PieceType.SEAPOST_PIECE, 0, structureTemplateManager, resourceLocation, resourceLocation.toString(), SeapostPiece.makeSettings(rotation, resourceLocation), SeapostPiece.makePosition(resourceLocation, blockPos, offset));
        }

        public SeapostPiece(StructureTemplateManager structureTemplateManager, CompoundTag compoundTag) {
            super(FOTStructures.PieceType.SEAPOST_PIECE, compoundTag, structureTemplateManager, resourceLocation -> SeapostPiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rot")), resourceLocation));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, ResourceLocation location) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74385_(PIVOTS.get(location)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos pos, int down) {
            return pos.m_121955_((Vec3i)OFFSETS.get(location)).m_6625_(down);
        }

        private ResourceLocation getRandomLootTables(RandomSource random) {
            if (random.m_188501_() < 0.35f) {
                return FOTLootTables.Chests.SEAPOST_BARREL_COMBAT;
            }
            if (random.m_188501_() < 0.2f) {
                return FOTLootTables.Chests.SEAPOST_BARREL_FIREWORK;
            }
            return FOTLootTables.Chests.SEAPOST_BARREL_SUPPLY;
        }

        protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
            switch (name) {
                case "seapost_barrel": {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)this.getRandomLootTables(random));
                    break;
                }
                case "seapost_barrel_with_flower_pot": {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)this.getRandomLootTables(random));
                    level.m_7731_(pos, ((Block)Util.m_214621_(POTTED_BLOCKS, (RandomSource)random)).m_49966_(), 2);
                    break;
                }
                case "seapost_leather_worker": {
                    Villager villager = (Villager)EntityType.f_20492_.m_20615_((Level)level.m_6018_());
                    villager.m_34375_(new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35593_, 1));
                    villager.m_21530_();
                    villager.m_20035_(pos, 0.0f, 0.0f);
                    villager.m_6518_(level, level.m_6436_(villager.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    level.m_47205_((Entity)villager);
                    level.m_7731_(pos, (BlockState)((BlockState)((BlockState)Blocks.f_50217_.m_49966_().m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)this.f_73657_.m_74404_().m_55954_(Direction.NORTH))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.TOP)).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true)), 2);
                    break;
                }
                case "seapost_fisherman": {
                    Villager villager = (Villager)EntityType.f_20492_.m_20615_((Level)level.m_6018_());
                    villager.m_34375_(new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35591_, 1));
                    villager.m_21530_();
                    villager.m_20035_(pos, 0.0f, 0.0f);
                    villager.m_6518_(level, level.m_6436_(villager.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    level.m_47205_((Entity)villager);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }

        public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            ResourceLocation resourceLocation = new ResourceLocation(this.f_163658_);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), generator.m_6337_() - OFFSETS.get(resourceLocation).m_123342_(), this.f_73658_.m_123343_());
            super.m_213694_(level, structureManager, generator, random, box, chunkPos, pos);
        }
    }
}

