/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.utils;

import com.stevekung.fishofthieves.mixin.accessor.PointedDripstoneBlockAccessor;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class CauldronUtils {
    private static final Predicate<BlockState> IS_CAULDRON = blockState -> blockState.m_60734_() instanceof AbstractCauldronBlock;

    public static void fillCauldronFromLeavesTail(BlockState state, ServerLevel level, BlockPos pos) {
        Optional<BlockPos> optional = CauldronUtils.findFillableCauldronBelowLeavesTail((Level)level, pos);
        if (optional.isPresent()) {
            BlockPos blockPos2 = optional.get();
            BlockState blockState2 = level.m_8055_(blockPos2);
            boolean trigger = false;
            if (blockState2.m_60734_() != Blocks.f_152476_) {
                blockState = Blocks.f_152476_.m_49966_();
                level.m_46597_(blockPos2, blockState);
                level.m_220407_(GameEvent.f_157792_, blockPos2, GameEvent.Context.m_223722_((BlockState)blockState));
                level.m_46796_(1047, blockPos2, 0);
                trigger = true;
            } else if (!((LayeredCauldronBlock)blockState2.m_60734_()).m_142596_(blockState2)) {
                blockState = (BlockState)blockState2.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)blockState2.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1));
                level.m_46597_(blockPos2, blockState);
                level.m_220407_(GameEvent.f_157792_, blockPos2, GameEvent.Context.m_223722_((BlockState)blockState));
                level.m_46796_(1047, blockPos2, 0);
                trigger = true;
            }
            if (trigger) {
                for (ServerPlayer serverPlayer : level.m_45955_(TargetingConditions.m_148353_(), null, new AABB(pos).m_82400_(8.0)).stream().map(ServerPlayer.class::cast).toList()) {
                    FOTCriteriaTriggers.WATER_DRIP_ON_BLOCK.trigger(level, pos, serverPlayer, state);
                }
            }
        }
    }

    public static Optional<BlockPos> findFillableCauldronBelowLeavesTail(Level level, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccessor.invokeCanDripThrough((BlockGetter)level, blockPos, blockState);
        return PointedDripstoneBlockAccessor.invokeFindBlockVertical((LevelAccessor)level, pos, Direction.DOWN.m_122421_(), biPredicate, IS_CAULDRON, 11);
    }
}

