/*
 * Decompiled with CFR 0.152.
 */
package net.czachor0.simplesilver.event;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import net.czachor0.simplesilver.block.ModBlocks;
import net.czachor0.simplesilver.effect.ModEffects;
import net.czachor0.simplesilver.item.ModItems;
import net.czachor0.simplesilver.potion.ModPotions;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplesilver")
public class ModEvents {
    private static final Supplier<Set<ItemLike>> SILVER_TOOLS = () -> Set.of((ItemLike)ModItems.SILVER_SHOVEL.get(), (ItemLike)ModItems.SILVER_PICKAXE.get(), (ItemLike)ModItems.SILVER_AXE.get(), (ItemLike)ModItems.SILVER_HOE.get(), (ItemLike)ModItems.SILVER_SWORD.get());
    private static final Supplier<Set<ItemLike>> SILVER_ARMOR = () -> Set.of((ItemLike)ModItems.SILVER_HELMET.get(), (ItemLike)ModItems.SILVER_CHESTPLATE.get(), (ItemLike)ModItems.SILVER_LEGGINGS.get(), (ItemLike)ModItems.SILVER_BOOTS.get());
    private static final Supplier<Set<Potion>> SILVER_POTIONS = () -> Set.of((Potion)ModPotions.SILVER_POTION.get(), (Potion)ModPotions.LONG_SILVER_POTION.get());

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (ModEvents.silverTools().contains(stack.m_41720_())) {
            ModEvents.modTooltip(event, "+2 Attack Damage Against Undead");
        }
        if (ModEvents.silverArmor().contains(stack.m_41720_())) {
            int bonusArmor = stack.m_41720_() == ModItems.SILVER_CHESTPLATE.get() ? 2 : 1;
            int bonusToughness = 3;
            ModEvents.modTooltip(event, "+" + bonusArmor + " Armor Against Undead");
            ModEvents.modTooltip(event, "+" + bonusToughness + " Armor Toughness Against Undead");
        }
        if (ModEvents.silverPotions().contains(potion)) {
            ModEvents.modTooltip(event, "Rotten Flesh: +1 Food, +6 Saturation");
        }
        if (potion == ModPotions.STRONG_SILVER_POTION.get()) {
            ModEvents.modTooltip(event, "Rotten Flesh: +4 Food, +12 Saturation");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_6336_() != MobType.f_21641_) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        ItemStack heldItem = attacker.m_21205_();
        if (ModEvents.silverTools().contains(heldItem.m_41720_())) {
            event.setAmount(event.getAmount() + 2.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onMobKilled(LivingDeathEvent event) {
        if (event.getEntity().m_6336_() != MobType.f_21641_) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)source;
        ItemStack heldItem = serverPlayer.m_21205_();
        if (ModEvents.silverTools().contains(heldItem.m_41720_())) {
            ModEvents.modAdvancement(serverPlayer, "adv_silver_sword");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)sourceEntity;
        if (attacker.m_6336_() != MobType.f_21641_) {
            return;
        }
        int baseArmor = serverPlayer.m_21230_();
        float baseToughness = 0.0f;
        float bonusToughness = 0.0f;
        int bonusArmor = 0;
        for (EquipmentSlot slot : EnumSet.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            ItemStack itemStack = serverPlayer.m_6844_(slot);
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                baseToughness += armorItem.m_40405_();
            }
            if (!ModEvents.silverArmor().contains(itemStack.m_41720_())) continue;
            bonusToughness += 3.0f;
            ++bonusArmor;
            if (slot != EquipmentSlot.CHEST) continue;
            ++bonusArmor;
        }
        float damage = event.getAmount();
        float reducedDamage = ModEvents.calculateArmorReducedDamage(damage, baseArmor + bonusArmor, baseToughness + bonusToughness);
        event.setAmount(reducedDamage);
        if (bonusArmor > 0) {
            ModEvents.modAdvancement(serverPlayer, "adv_silver_chestplate");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemUseFinished(LivingEntityUseItemEvent.Finish event) {
        ServerPlayer serverPlayer;
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem();
        if (entity instanceof ServerPlayer && ((serverPlayer = (ServerPlayer)entity).m_21023_((MobEffect)ModEffects.HUNGER_RESISTANCE.get()) || serverPlayer.m_21023_((MobEffect)ModEffects.HUNGER_RESISTANCE_II.get()))) {
            serverPlayer.m_21195_(MobEffects.f_19612_);
            if (item.m_41720_() == Items.f_42583_) {
                if (serverPlayer.m_21023_((MobEffect)ModEffects.HUNGER_RESISTANCE.get())) {
                    serverPlayer.m_36324_().m_38707_(1, 6.0f);
                    ModEvents.modAdvancement(serverPlayer, "adv_rotten_flesh");
                } else if (serverPlayer.m_21023_((MobEffect)ModEffects.HUNGER_RESISTANCE_II.get())) {
                    serverPlayer.m_36324_().m_38707_(4, 12.0f);
                    ModEvents.modAdvancement(serverPlayer, "adv_rotten_flesh");
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (event.getState().m_60734_() == ModBlocks.SILVER_ORE.get() || event.getState().m_60734_() == ModBlocks.DEEPSLATE_SILVER_ORE.get()) {
            ModEvents.modAdvancement(serverPlayer, "adv_silver_ore");
        } else if (event.getState().m_60734_() == ModBlocks.BASALT_SILVER_ORE.get()) {
            ModEvents.modAdvancement(serverPlayer, "adv_basalt_silver_ore");
        }
    }

    private static Set<ItemLike> silverTools() {
        return SILVER_TOOLS.get();
    }

    private static Set<ItemLike> silverArmor() {
        return SILVER_ARMOR.get();
    }

    private static Set<Potion> silverPotions() {
        return SILVER_POTIONS.get();
    }

    private static void modTooltip(ItemTooltipEvent event, String text) {
        event.getToolTip().add(Component.m_237113_((String)text).m_130938_(style -> style.m_178520_(7441570)));
    }

    private static float calculateArmorReducedDamage(float damage, int armor, float toughness) {
        float armorFactor = Math.min(20.0f, Math.max((float)armor / 5.0f, (float)armor - damage / (2.0f + toughness / 4.0f)));
        return damage * (1.0f - armorFactor / 25.0f);
    }

    public static void modAdvancement(ServerPlayer serverPlayer, String path) {
        AdvancementProgress progress;
        ResourceLocation advancementId = new ResourceLocation("simplesilver", path);
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(advancementId);
        if (advancement != null && !(progress = serverPlayer.m_8960_().m_135996_(advancement)).m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                serverPlayer.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }
}

