/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.beautifiedchatserver_common_fabric.config.ConfigHandler;
import com.natamus.beautifiedchatserver_common_fabric.data.Chat;
import com.natamus.beautifiedchatserver_common_fabric.util.Util;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BeautifulChatEvent {
    public static Pair<Boolean, class_2561> onServerChat(class_3222 serverPlayer, class_2561 messageComponent, UUID uuid) {
        String timestamp = new SimpleDateFormat(ConfigHandler.timestampFormat).format(new Date());
        String playerName = serverPlayer.method_5477().getString();
        String message = messageComponent.getString();
        if (!message.contains(playerName)) {
            return null;
        }
        if (message.contains("> ")) {
            message = message.substring(message.split("> ")[0].length() + 2);
        }
        class_5250 output = class_2561.method_43470((String)"");
        String raw_outputstring = ConfigHandler.chatMessageFormat;
        for (String word : raw_outputstring.split("%")) {
            class_124 colour = Util.getColour(word, playerName);
            Object toAppendString = word;
            if (word.equalsIgnoreCase("timestamp")) {
                toAppendString = timestamp;
            } else if (word.equalsIgnoreCase("username")) {
                Optional<String> optionalPlayerRank;
                toAppendString = playerName;
                if (ConfigHandler.showRankTitles && (optionalPlayerRank = Util.getRankOfPlayer(playerName)).isPresent()) {
                    String rankFormat = ConfigHandler.rankTitleFormat;
                    toAppendString = rankFormat.replace("%rank", StringFunctions.capitalizeEveryWord((String)optionalPlayerRank.get())) + (String)toAppendString;
                }
            } else if (word.equalsIgnoreCase("chatmessage")) {
                toAppendString = message;
            }
            class_5250 wordcomponent = class_2561.method_43470((String)toAppendString);
            wordcomponent.method_27692(colour);
            output.method_10852((class_2561)wordcomponent);
        }
        Chat.logger.info(output.getString());
        return new Pair((Object)true, (Object)output);
    }
}

