/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.beautifiedchatserver_common_forge.config.ConfigHandler;
import com.natamus.beautifiedchatserver_common_forge.data.Chat;
import com.natamus.beautifiedchatserver_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.StringFunctions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class BeautifulChatEvent {
    public static Pair<Boolean, Component> onServerChat(ServerPlayer serverPlayer, Component messageComponent, UUID uuid) {
        String timestamp = new SimpleDateFormat(ConfigHandler.timestampFormat).format(new Date());
        String playerName = serverPlayer.getName().getString();
        String message = messageComponent.getString();
        if (!message.contains(playerName)) {
            return null;
        }
        if (message.contains("> ")) {
            message = message.substring(message.split("> ")[0].length() + 2);
        }
        MutableComponent output = Component.literal((String)"");
        String raw_outputstring = ConfigHandler.chatMessageFormat;
        for (String word : raw_outputstring.split("%")) {
            ChatFormatting colour = Util.getColour(word, playerName);
            Object toAppendString = word;
            if (word.equalsIgnoreCase("timestamp")) {
                toAppendString = timestamp;
            } else if (word.equalsIgnoreCase("username")) {
                Optional<String> optionalPlayerRank;
                toAppendString = playerName;
                if (ConfigHandler.showRankTitles && (optionalPlayerRank = Util.getRankOfPlayer(playerName)).isPresent()) {
                    String rankFormat = ConfigHandler.rankTitleFormat;
                    toAppendString = rankFormat.replace("%rank", StringFunctions.capitalizeEveryWord((String)optionalPlayerRank.get())) + (String)toAppendString;
                }
            } else if (word.equalsIgnoreCase("chatmessage")) {
                toAppendString = message;
            }
            MutableComponent wordcomponent = Component.literal((String)toAppendString);
            wordcomponent.withStyle(colour);
            output.append((Component)wordcomponent);
        }
        Chat.logger.info(output.getString());
        return new Pair((Object)true, (Object)output);
    }
}

