/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_forge.cmd;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.beautifiedchatserver_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandBCS {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (String commandPrefix : Arrays.asList("beautifiedchatserver", "bcs")) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandPrefix).requires(iCommandSender -> iCommandSender.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rank").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"rank-name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestsColors).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String colorStr = StringArgumentType.getString((CommandContext)command, (String)"color");
                ChatFormatting color = Util.parseColor(colorStr);
                if (color == null) {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)Util.prefix().m_7220_((Component)Util.text("Unknown color: ", ChatFormatting.RED)).m_7220_((Component)Util.text(colorStr, ChatFormatting.WHITE)));
                    return 0;
                }
                boolean changed = Util.addOrUpdateRank(rankName, color);
                if (changed) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).m_7220_((Component)Util.text(" set to color ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(color.m_126666_(), color)), (boolean)true);
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).m_7220_((Component)Util.text(" already had color ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(color.m_126666_(), color)), (boolean)true);
                }
                return 1;
            }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                boolean removed = Util.removeRank(rankName);
                if (removed) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Removed rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                    return 1;
                }
                ((CommandSourceStack)command.getSource()).m_81352_((Component)Util.prefix().m_7220_((Component)Util.text("Rank ", ChatFormatting.RED)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).m_7220_((Component)Util.text(" does not exist.", ChatFormatting.RED)));
                return 0;
            })))).then(Commands.m_82127_((String)"list").executes(command -> {
                JsonObject ranks = Util.readJsonObjectSafe(Util.ranksPathString());
                if (ranks.size() == 0) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("No ranks defined.", ChatFormatting.GRAY)), (boolean)true);
                    return 1;
                }
                MutableComponent out = Util.prefix().m_7220_((Component)Util.text("Ranks:", ChatFormatting.GOLD));
                for (String key : Util.sortedKeys(ranks)) {
                    String colorName = Util.asString(ranks.get(key));
                    ChatFormatting cf = colorName != null ? Util.parseColor(colorName) : null;
                    out.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Util.text("- ", ChatFormatting.DARK_GRAY)).m_7220_((Component)Util.text(key, ChatFormatting.AQUA)).m_7220_((Component)Util.text(" = ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(colorName == null ? "UNKNOWN" : colorName, cf != null ? cf : ChatFormatting.WHITE));
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)out, (boolean)true);
                return 1;
            })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player-name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (Util.rankEquals(current, rankName)) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Player ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(playerName, ChatFormatting.GREEN)).m_7220_((Component)Util.text(" is already in rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(current), ChatFormatting.AQUA)), (boolean)true);
                    return 1;
                }
                String outcome = Util.togglePlayerRank(playerName, rankName);
                if ("removed".equals(outcome)) {
                    Util.togglePlayerRank(playerName, rankName);
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Player ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(playerName, ChatFormatting.GREEN)).m_7220_((Component)Util.text(" added to rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                return 1;
            }))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player-name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (!Util.rankEquals(current, rankName)) {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)Util.prefix().m_7220_((Component)Util.text("Player ", ChatFormatting.RED)).m_7220_((Component)Util.text(playerName, ChatFormatting.GREEN)).m_7220_((Component)Util.text(" is not in rank ", ChatFormatting.RED)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).m_7220_((Component)Util.text(".", ChatFormatting.RED)));
                    return 0;
                }
                Util.togglePlayerRank(playerName, rankName);
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("Removed player ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(playerName, ChatFormatting.GREEN)).m_7220_((Component)Util.text(" from rank ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                return 1;
            }))))).then(Commands.m_82127_((String)"list").executes(command -> {
                JsonObject players = Util.readJsonObjectSafe(Util.playersPathString());
                if (players.size() == 0) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().m_7220_((Component)Util.text("No players assigned to ranks.", ChatFormatting.GRAY)), (boolean)true);
                    return 1;
                }
                MutableComponent out = Util.prefix().m_7220_((Component)Util.text("Players with ranks:", ChatFormatting.GOLD));
                for (String player : Util.sortedKeys(players)) {
                    String rank = Util.asString(players.get(player));
                    ChatFormatting cf = rank != null ? Util.parseColor(Util.getRankColor(rank).map(ChatFormatting::m_126666_).orElse(rank)) : null;
                    out.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Util.text("- ", ChatFormatting.DARK_GRAY)).m_7220_((Component)Util.text(player, ChatFormatting.GREEN)).m_7220_((Component)Util.text(" -> ", ChatFormatting.GRAY)).m_7220_((Component)Util.text(rank == null ? "UNKNOWN" : Util.norm(rank), ChatFormatting.AQUA));
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)out, (boolean)true);
                return 1;
            }))));
        }
    }
}

