/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_fabric.cmd;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.beautifiedchatserver_common_fabric.util.Util;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CommandBCS {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        for (String commandPrefix : Arrays.asList("beautifiedchatserver", "bcs")) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandPrefix).requires(iCommandSender -> iCommandSender.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rank").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"rank-name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestsColors).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String colorStr = StringArgumentType.getString((CommandContext)command, (String)"color");
                class_124 color = Util.parseColor(colorStr);
                if (color == null) {
                    ((class_2168)command.getSource()).method_9213((class_2561)Util.prefix().method_10852((class_2561)Util.text("Unknown color: ", class_124.field_1061)).method_10852((class_2561)Util.text(colorStr, class_124.field_1068)));
                    return 0;
                }
                boolean changed = Util.addOrUpdateRank(rankName, color);
                if (changed) {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)).method_10852((class_2561)Util.text(" set to color ", class_124.field_1080)).method_10852((class_2561)Util.text(color.method_537(), color)), (boolean)true);
                } else {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)).method_10852((class_2561)Util.text(" already had color ", class_124.field_1080)).method_10852((class_2561)Util.text(color.method_537(), color)), (boolean)true);
                }
                return 1;
            }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                boolean removed = Util.removeRank(rankName);
                if (removed) {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Removed rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)), (boolean)true);
                    return 1;
                }
                ((class_2168)command.getSource()).method_9213((class_2561)Util.prefix().method_10852((class_2561)Util.text("Rank ", class_124.field_1061)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)).method_10852((class_2561)Util.text(" does not exist.", class_124.field_1061)));
                return 0;
            })))).then(class_2170.method_9247((String)"list").executes(command -> {
                JsonObject ranks = Util.readJsonObjectSafe(Util.ranksPathString());
                if (ranks.size() == 0) {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("No ranks defined.", class_124.field_1080)), (boolean)true);
                    return 1;
                }
                class_5250 out = Util.prefix().method_10852((class_2561)Util.text("Ranks:", class_124.field_1065));
                for (String key : Util.sortedKeys(ranks)) {
                    String colorName = Util.asString(ranks.get(key));
                    class_124 cf = colorName != null ? Util.parseColor(colorName) : null;
                    out.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)Util.text("- ", class_124.field_1063)).method_10852((class_2561)Util.text(key, class_124.field_1075)).method_10852((class_2561)Util.text(" = ", class_124.field_1080)).method_10852((class_2561)Util.text(colorName == null ? "UNKNOWN" : colorName, cf != null ? cf : class_124.field_1068));
                }
                MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)out, (boolean)true);
                return 1;
            })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player-name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (Util.rankEquals(current, rankName)) {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Player ", class_124.field_1080)).method_10852((class_2561)Util.text(playerName, class_124.field_1060)).method_10852((class_2561)Util.text(" is already in rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(current), class_124.field_1075)), (boolean)true);
                    return 1;
                }
                String outcome = Util.togglePlayerRank(playerName, rankName);
                if ("removed".equals(outcome)) {
                    Util.togglePlayerRank(playerName, rankName);
                }
                MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Player ", class_124.field_1080)).method_10852((class_2561)Util.text(playerName, class_124.field_1060)).method_10852((class_2561)Util.text(" added to rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)), (boolean)true);
                return 1;
            }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player-name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (!Util.rankEquals(current, rankName)) {
                    ((class_2168)command.getSource()).method_9213((class_2561)Util.prefix().method_10852((class_2561)Util.text("Player ", class_124.field_1061)).method_10852((class_2561)Util.text(playerName, class_124.field_1060)).method_10852((class_2561)Util.text(" is not in rank ", class_124.field_1061)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)).method_10852((class_2561)Util.text(".", class_124.field_1061)));
                    return 0;
                }
                Util.togglePlayerRank(playerName, rankName);
                MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("Removed player ", class_124.field_1080)).method_10852((class_2561)Util.text(playerName, class_124.field_1060)).method_10852((class_2561)Util.text(" from rank ", class_124.field_1080)).method_10852((class_2561)Util.text(Util.norm(rankName), class_124.field_1075)), (boolean)true);
                return 1;
            }))))).then(class_2170.method_9247((String)"list").executes(command -> {
                JsonObject players = Util.readJsonObjectSafe(Util.playersPathString());
                if (players.size() == 0) {
                    MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)Util.prefix().method_10852((class_2561)Util.text("No players assigned to ranks.", class_124.field_1080)), (boolean)true);
                    return 1;
                }
                class_5250 out = Util.prefix().method_10852((class_2561)Util.text("Players with ranks:", class_124.field_1065));
                for (String player : Util.sortedKeys(players)) {
                    String rank = Util.asString(players.get(player));
                    class_124 cf = rank != null ? Util.parseColor(Util.getRankColor(rank).map(class_124::method_537).orElse(rank)) : null;
                    out.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)Util.text("- ", class_124.field_1063)).method_10852((class_2561)Util.text(player, class_124.field_1060)).method_10852((class_2561)Util.text(" -> ", class_124.field_1080)).method_10852((class_2561)Util.text(rank == null ? "UNKNOWN" : Util.norm(rank), class_124.field_1075));
                }
                MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (class_5250)out, (boolean)true);
                return 1;
            }))));
        }
    }
}

