/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.vami.zoe.entity.ArbiterEntity;
import net.vami.zoe.entity.AtrophyEntity;
import net.vami.zoe.entity.BiostationEntity;
import net.vami.zoe.entity.CyborgEntity;
import net.vami.zoe.entity.CycrawlerEntity;
import net.vami.zoe.entity.CyhoblinEntity;
import net.vami.zoe.entity.DeathProjectileEntity;
import net.vami.zoe.entity.EnvoyEntity;
import net.vami.zoe.entity.FyberEntity;
import net.vami.zoe.entity.IntrovercyEntity;
import net.vami.zoe.entity.IsolationEntity;
import net.vami.zoe.entity.MaliceEntity;
import net.vami.zoe.entity.MercyWaveEntity;
import net.vami.zoe.entity.PlasmanadeEntity;
import net.vami.zoe.entity.PortEntity;
import net.vami.zoe.entity.QuantumArcEntity;
import net.vami.zoe.entity.RejectionEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZoeModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"zoe");
    public static final RegistryObject<EntityType<CyborgEntity>> CYBORG = ZoeModEntities.register("cyborg", EntityType.Builder.m_20704_(CyborgEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(CyborgEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<MercyWaveEntity>> MERCY_WAVE = ZoeModEntities.register("mercy_wave", EntityType.Builder.m_20704_(MercyWaveEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(MercyWaveEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<BiostationEntity>> BIOSTATION = ZoeModEntities.register("biostation", EntityType.Builder.m_20704_(BiostationEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(1024).setUpdateInterval(3).setCustomClientFactory(BiostationEntity::new).m_20699_(1.4f, 1.2f));
    public static final RegistryObject<EntityType<FyberEntity>> FYBER = ZoeModEntities.register("fyber", EntityType.Builder.m_20704_(FyberEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(FyberEntity::new).m_20699_(1.2f, 0.8f));
    public static final RegistryObject<EntityType<CycrawlerEntity>> CYCRAWLER = ZoeModEntities.register("cycrawler", EntityType.Builder.m_20704_(CycrawlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(CycrawlerEntity::new).m_20699_(1.6f, 1.0f));
    public static final RegistryObject<EntityType<IntrovercyEntity>> INTROVERCY = ZoeModEntities.register("introvercy", EntityType.Builder.m_20704_(IntrovercyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1024).setUpdateInterval(3).setCustomClientFactory(IntrovercyEntity::new).m_20699_(0.6f, 2.2f));
    public static final RegistryObject<EntityType<IsolationEntity>> ISOLATION = ZoeModEntities.register("isolation", EntityType.Builder.m_20704_(IsolationEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(IsolationEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RejectionEntity>> REJECTION = ZoeModEntities.register("rejection", EntityType.Builder.m_20704_(RejectionEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RejectionEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<MaliceEntity>> MALICE = ZoeModEntities.register("malice", EntityType.Builder.m_20704_(MaliceEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(MaliceEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<AtrophyEntity>> ATROPHY = ZoeModEntities.register("atrophy", EntityType.Builder.m_20704_(AtrophyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1024).setUpdateInterval(3).setCustomClientFactory(AtrophyEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<QuantumArcEntity>> QUANTUM_ARC = ZoeModEntities.register("quantum_arc", EntityType.Builder.m_20704_(QuantumArcEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(512).setUpdateInterval(3).setCustomClientFactory(QuantumArcEntity::new).m_20699_(0.1f, 1.0f));
    public static final RegistryObject<EntityType<DeathProjectileEntity>> DEATH = ZoeModEntities.register("death", EntityType.Builder.m_20704_(DeathProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(DeathProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<EnvoyEntity>> ENVOY = ZoeModEntities.register("envoy", EntityType.Builder.m_20704_(EnvoyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).setCustomClientFactory(EnvoyEntity::new).m_20699_(1.6f, 4.6f));
    public static final RegistryObject<EntityType<PlasmanadeEntity>> PLASMANADE = ZoeModEntities.register("plasmanade", EntityType.Builder.m_20704_(PlasmanadeEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(PlasmanadeEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<ArbiterEntity>> ARBITER = ZoeModEntities.register("arbiter", EntityType.Builder.m_20704_(ArbiterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).setCustomClientFactory(ArbiterEntity::new).m_20719_().m_20699_(1.2f, 2.2f));
    public static final RegistryObject<EntityType<PortEntity>> PORT = ZoeModEntities.register("port", EntityType.Builder.m_20704_(PortEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).setCustomClientFactory(PortEntity::new).m_20719_().m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<CyhoblinEntity>> CYHOBLIN = ZoeModEntities.register("cyhoblin", EntityType.Builder.m_20704_(CyhoblinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(192).setUpdateInterval(3).setCustomClientFactory(CyhoblinEntity::new).m_20719_().m_20699_(0.4f, 0.6f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CyborgEntity.init();
            BiostationEntity.init();
            FyberEntity.init();
            CycrawlerEntity.init();
            IntrovercyEntity.init();
            AtrophyEntity.init();
            QuantumArcEntity.init();
            EnvoyEntity.init();
            ArbiterEntity.init();
            PortEntity.init();
            CyhoblinEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CYBORG.get(), CyborgEntity.createAttributes().m_22265_());
        event.put((EntityType)BIOSTATION.get(), BiostationEntity.createAttributes().m_22265_());
        event.put((EntityType)FYBER.get(), FyberEntity.createAttributes().m_22265_());
        event.put((EntityType)CYCRAWLER.get(), CycrawlerEntity.createAttributes().m_22265_());
        event.put((EntityType)INTROVERCY.get(), IntrovercyEntity.createAttributes().m_22265_());
        event.put((EntityType)ATROPHY.get(), AtrophyEntity.createAttributes().m_22265_());
        event.put((EntityType)QUANTUM_ARC.get(), QuantumArcEntity.createAttributes().m_22265_());
        event.put((EntityType)ENVOY.get(), EnvoyEntity.createAttributes().m_22265_());
        event.put((EntityType)ARBITER.get(), ArbiterEntity.createAttributes().m_22265_());
        event.put((EntityType)PORT.get(), PortEntity.createAttributes().m_22265_());
        event.put((EntityType)CYHOBLIN.get(), CyhoblinEntity.createAttributes().m_22265_());
    }
}

