/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.vami.zoe.ZoeMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZoeModVariables {
    public static String implantConfigPath = "/config/zoe/implants";
    public static String enhancerConfigPath = "/config/zoe/enhancers";
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ZoeMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ZoeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.implant0 = message.data.implant0;
                    variables.implant1 = message.data.implant1;
                    variables.implant2 = message.data.implant2;
                    variables.implant3 = message.data.implant3;
                    variables.implant4 = message.data.implant4;
                    variables.implant5 = message.data.implant5;
                    variables.implant6 = message.data.implant6;
                    variables.implant7 = message.data.implant7;
                    variables.implant8 = message.data.implant8;
                    variables.implant9 = message.data.implant9;
                    variables.implant10 = message.data.implant10;
                    variables.implant11 = message.data.implant11;
                    variables.implant12 = message.data.implant12;
                    variables.implant13 = message.data.implant13;
                    variables.implant14 = message.data.implant14;
                    variables.implant15 = message.data.implant15;
                    variables.implant16 = message.data.implant16;
                    variables.implant17 = message.data.implant17;
                    variables.cybertechne = message.data.cybertechne;
                    variables.armatechne = message.data.armatechne;
                    variables.biotechne = message.data.biotechne;
                    variables.robotechne = message.data.robotechne;
                    variables.walkMode = message.data.walkMode;
                    variables.implantCooldownMessage = message.data.implantCooldownMessage;
                    variables.software = message.data.software;
                    variables.currentCyberstation = message.data.currentCyberstation;
                    variables.viewImplantPlayerUUID = message.data.viewImplantPlayerUUID;
                    variables.hasImplant = message.data.hasImplant;
                    variables.ownedMobs = message.data.ownedMobs;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public ItemStack implant0 = ItemStack.f_41583_;
        public ItemStack implant1 = ItemStack.f_41583_;
        public ItemStack implant2 = ItemStack.f_41583_;
        public ItemStack implant3 = ItemStack.f_41583_;
        public ItemStack implant4 = ItemStack.f_41583_;
        public ItemStack implant5 = ItemStack.f_41583_;
        public ItemStack implant6 = ItemStack.f_41583_;
        public ItemStack implant7 = ItemStack.f_41583_;
        public ItemStack implant8 = ItemStack.f_41583_;
        public ItemStack implant9 = ItemStack.f_41583_;
        public ItemStack implant10 = ItemStack.f_41583_;
        public ItemStack implant11 = ItemStack.f_41583_;
        public ItemStack implant12 = ItemStack.f_41583_;
        public ItemStack implant13 = ItemStack.f_41583_;
        public ItemStack implant14 = ItemStack.f_41583_;
        public ItemStack implant15 = ItemStack.f_41583_;
        public ItemStack implant16 = ItemStack.f_41583_;
        public ItemStack implant17 = ItemStack.f_41583_;
        public double cybertechne = 1.0;
        public double armatechne = 1.0;
        public double biotechne = 1.0;
        public double robotechne = 1.0;
        public boolean walkMode = false;
        public boolean implantCooldownMessage = false;
        public ItemStack software = ItemStack.f_41583_;
        public BlockState currentCyberstation = Blocks.f_50016_.m_49966_();
        public String viewImplantPlayerUUID = "\"\"";
        public boolean hasImplant = false;
        public String ownedMobs = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ZoeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("implant0", (Tag)this.implant0.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant1", (Tag)this.implant1.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant2", (Tag)this.implant2.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant3", (Tag)this.implant3.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant4", (Tag)this.implant4.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant5", (Tag)this.implant5.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant6", (Tag)this.implant6.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant7", (Tag)this.implant7.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant8", (Tag)this.implant8.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant9", (Tag)this.implant9.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant10", (Tag)this.implant10.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant11", (Tag)this.implant11.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant12", (Tag)this.implant12.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant13", (Tag)this.implant13.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant14", (Tag)this.implant14.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant15", (Tag)this.implant15.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant16", (Tag)this.implant16.m_41739_(new CompoundTag()));
            nbt.m_128365_("implant17", (Tag)this.implant17.m_41739_(new CompoundTag()));
            nbt.m_128347_("cybertechne", this.cybertechne);
            nbt.m_128347_("armatechne", this.armatechne);
            nbt.m_128347_("biotechne", this.biotechne);
            nbt.m_128347_("robotechne", this.robotechne);
            nbt.m_128379_("walkMode", this.walkMode);
            nbt.m_128379_("implantCooldownMessage", this.implantCooldownMessage);
            nbt.m_128365_("software", (Tag)this.software.m_41739_(new CompoundTag()));
            nbt.m_128365_("currentCyberstation", (Tag)NbtUtils.m_129202_((BlockState)this.currentCyberstation));
            nbt.m_128359_("viewImplantPlayerUUID", this.viewImplantPlayerUUID);
            nbt.m_128379_("hasImplant", this.hasImplant);
            nbt.m_128359_("ownedMobs", this.ownedMobs);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.implant0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant0"));
            this.implant1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant1"));
            this.implant2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant2"));
            this.implant3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant3"));
            this.implant4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant4"));
            this.implant5 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant5"));
            this.implant6 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant6"));
            this.implant7 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant7"));
            this.implant8 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant8"));
            this.implant9 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant9"));
            this.implant10 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant10"));
            this.implant11 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant11"));
            this.implant12 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant12"));
            this.implant13 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant13"));
            this.implant14 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant14"));
            this.implant15 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant15"));
            this.implant16 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant16"));
            this.implant17 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("implant17"));
            this.cybertechne = nbt.m_128459_("cybertechne");
            this.armatechne = nbt.m_128459_("armatechne");
            this.biotechne = nbt.m_128459_("biotechne");
            this.robotechne = nbt.m_128459_("robotechne");
            this.walkMode = nbt.m_128471_("walkMode");
            this.implantCooldownMessage = nbt.m_128471_("implantCooldownMessage");
            this.software = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("software"));
            this.currentCyberstation = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("currentCyberstation"));
            this.viewImplantPlayerUUID = nbt.m_128461_("viewImplantPlayerUUID");
            this.hasImplant = nbt.m_128471_("hasImplant");
            this.ownedMobs = nbt.m_128461_("ownedMobs");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("zoe", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "zoe_mapvars";
        public String assimilatedPlayer = "\"\"";
        public String lastAssimilatedCommand = "\"\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.assimilatedPlayer = nbt.m_128461_("assimilatedPlayer");
            this.lastAssimilatedCommand = nbt.m_128461_("lastAssimilatedCommand");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("assimilatedPlayer", this.assimilatedPlayer);
            nbt.m_128359_("lastAssimilatedCommand", this.lastAssimilatedCommand);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ZoeMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "zoe_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ZoeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.implant0 = original.implant0;
            clone.implant1 = original.implant1;
            clone.implant2 = original.implant2;
            clone.implant3 = original.implant3;
            clone.implant4 = original.implant4;
            clone.implant5 = original.implant5;
            clone.implant6 = original.implant6;
            clone.implant7 = original.implant7;
            clone.implant8 = original.implant8;
            clone.implant9 = original.implant9;
            clone.implant10 = original.implant10;
            clone.implant11 = original.implant11;
            clone.implant12 = original.implant12;
            clone.implant13 = original.implant13;
            clone.implant14 = original.implant14;
            clone.implant15 = original.implant15;
            clone.implant16 = original.implant16;
            clone.implant17 = original.implant17;
            clone.cybertechne = original.cybertechne;
            clone.armatechne = original.armatechne;
            clone.biotechne = original.biotechne;
            clone.robotechne = original.robotechne;
            clone.walkMode = original.walkMode;
            clone.implantCooldownMessage = original.implantCooldownMessage;
            clone.software = original.software;
            clone.hasImplant = original.hasImplant;
            clone.ownedMobs = original.ownedMobs;
            if (!event.isWasDeath()) {
                clone.currentCyberstation = original.currentCyberstation;
                clone.viewImplantPlayerUUID = original.viewImplantPlayerUUID;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ZoeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ZoeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ZoeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

