/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.init.ZoeModBlocks;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class IonicCrucibleRenderProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IonicCrucibleRenderProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        IonicCrucibleRenderProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.m_60734_();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockEntity blockEntity = entityBlock.m_142194_(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                blockEntity.m_142339_((Level)level);
                blockEntityRenderer.m_6922_(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BlockRenderDispatcher dispatcher = minecraft.m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BakedModel bakedModel = dispatcher.m_110910_(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.m_85850_();
            int color = minecraft.m_91298_().m_92582_(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.m_6299_(Sheets.m_110792_()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.m_9236_() != level) {
                entity = type.m_20615_((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.m_20615_((Level)level);
            data.put(type, entity);
        }
        IonicCrucibleRenderProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick();
        int packedLight = glowing ? 0xF000F0 : Minecraft.m_91087_().m_91290_().m_114394_(entity, partialTick);
        IonicCrucibleRenderProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_(entity);
        Vec3 pos = provider.getCamera().m_90583_();
        float offset = entity.m_20206_() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y + (double)offset - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_7392_(entity, entity.m_5675_(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        ItemRenderer renderer = minecraft.m_91291_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_269491_(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.f_91073_, packedLight, OverlayTexture.f_118083_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).m_82541_().m_252839_();
        Matrix4f matrix4f = provider.getPoseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        vertexConsumer.m_252986_(matrix4f, (float)(x1 - pos.m_7096_()), (float)(y1 - pos.m_7098_()), (float)(z1 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x2 - pos.m_7096_()), (float)(y2 - pos.m_7098_()), (float)(z2 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            Vec3 pos = entity.m_20318_(provider.getPartialTick());
            IonicCrucibleRenderProcedure.execute((Event)provider, (LevelAccessor)level);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world) {
        IonicCrucibleRenderProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        double randX = 0.0;
        double randY = 0.0;
        double randZ = 0.0;
        double scale = 0.0;
        if (world instanceof ClientLevel) {
            ClientLevel _blockEntityContext = (ClientLevel)world;
            int _scanRange = Minecraft.m_91087_().f_91066_.m_193772_();
            BlockPos _scanCenter = Minecraft.m_91087_().f_91074_.m_20183_();
            for (int _chunkZ = -_scanRange; _chunkZ <= _scanRange; ++_chunkZ) {
                for (int _chunkX = -_scanRange; _chunkX <= _scanRange; ++_chunkX) {
                    LevelChunk _levelChunk = _blockEntityContext.m_6325_(SectionPos.m_123171_((int)(_scanCenter.m_123341_() + (_chunkX << 4))), SectionPos.m_123171_((int)(_scanCenter.m_123343_() + (_chunkZ << 4))));
                    if (_levelChunk == null) continue;
                    for (Map.Entry _blockEntityEntry : _levelChunk.m_62954_().entrySet()) {
                        int n;
                        BlockState blockstateiterator = ((BlockEntity)_blockEntityEntry.getValue()).m_58900_();
                        int positionx = ((BlockPos)_blockEntityEntry.getKey()).m_123341_();
                        int positiony = ((BlockPos)_blockEntityEntry.getKey()).m_123342_();
                        int positionz = ((BlockPos)_blockEntityEntry.getKey()).m_123343_();
                        if (blockstateiterator.m_60734_() != ZoeModBlocks.IONIC_CRUCIBLE.get()) continue;
                        Property property = blockstateiterator.m_60734_().m_49965_().m_61081_("blockstate");
                        if (property instanceof IntegerProperty) {
                            IntegerProperty _getip3 = (IntegerProperty)property;
                            n = (Integer)blockstateiterator.m_61143_((Property)_getip3);
                        } else {
                            n = -1;
                        }
                        scale = 0.01 * (double)n;
                        if (scale == 0.0) {
                            return;
                        }
                        randX = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)(scale * -1.0), (double)scale);
                        randY = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)(scale * -1.0), (double)scale);
                        randZ = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)(scale * -1.0), (double)scale);
                        IonicCrucibleRenderProcedure.renderBlock(blockstateiterator, (double)positionx + 0.5 + randX, (double)positiony + 0.5 + randY, (double)positionz + 0.5 + randZ, 0.0f, 0.0f, (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)(scale * -1.0), (double)scale), 1.0f, true);
                    }
                }
            }
        }
    }
}

