/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.vami.zoe.init.ZoeModBlocks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EgoDeathCone {
    public static void createCoarseDirtCone(Level level, Entity source, Entity target) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lookVec = source.m_20154_().m_82541_();
        Vec3 origin = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        double coneLength = 10.0;
        double coneAngle = Math.toRadians(30.0);
        SimpleParticleType egoParticle = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation("zoe", "ego"));
        for (double d = 1.0; d <= coneLength; d += 0.5) {
            for (int i = 0; i < 360; i += 10) {
                for (int j = -30; j <= 30; j += 10) {
                    double radius = d * Math.tan(coneAngle);
                    double angleRad = Math.toRadians(i);
                    double pitchRad = Math.toRadians(j);
                    Vec3 offset = new Vec3(Math.cos(angleRad) * Math.cos(pitchRad), Math.sin(pitchRad), Math.sin(angleRad) * Math.cos(pitchRad)).m_82541_().m_82490_(radius);
                    Vec3 posVec = origin.m_82549_(lookVec.m_82490_(d)).m_82549_(offset);
                    BlockPos blockPos = BlockPos.m_274446_((Position)posVec);
                    if (EgoDeathCone.isSafeToReplace(level.m_8055_(blockPos))) {
                        level.m_46597_(blockPos, EgoDeathCone.getReplacementBlock(level.m_8055_(blockPos)));
                    }
                    if (!(level.m_213780_().m_188501_() < 0.05f) || egoParticle == null) continue;
                    serverLevel.m_8767_((ParticleOptions)egoParticle, posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        AABB coneAABB = new AABB(origin.m_82492_(coneLength, coneLength, coneLength), origin.m_82520_(coneLength, coneLength, coneLength));
        List entities = serverLevel.m_6249_(target, coneAABB, e -> e != source);
        for (Entity entity : entities) {
            Vec3 toEntity = entity.m_20182_().m_82546_(origin).m_82541_();
            double angle = Math.acos(toEntity.m_82526_(lookVec));
            if (!(angle <= coneAngle)) continue;
            AABB box = entity.m_20191_().m_82400_(2.0);
            serverLevel.m_5594_(null, BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zoe:ego_death_scream")), SoundSource.MASTER, 1.0f, (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.7, (double)1.3));
            if (entity instanceof Player || entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("zoe:bypasses_ego")))) {
                float f;
                DamageSource damageSource = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("zoe:ego"))), source);
                if (entity instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entity;
                    f = _livEnt.m_21233_();
                } else {
                    f = -1.0f;
                }
                entity.m_6469_(damageSource, f);
            } else {
                entity.m_146870_();
            }
            BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_), (BlockPos)BlockPos.m_274561_((double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_)).forEach(pos -> {
                BlockState state = level.m_8055_(pos);
                if (EgoDeathCone.isSafeToReplace(state)) {
                    level.m_46597_(pos, EgoDeathCone.getReplacementBlock(state));
                }
            });
        }
    }

    public static void spherecastSurfaceToCoarseDirt(Level level, Player player, double radius) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 origin = player.m_146892_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int steps = 30;
        int segments = 20;
        for (int i = 0; i < steps; ++i) {
            double theta = Math.PI * 2 * ((double)i / (double)steps);
            block1: for (int j = 0; j < segments; ++j) {
                double phi = Math.PI * ((double)j / (double)segments);
                double xDir = Math.sin(phi) * Math.cos(theta);
                double yDir = Math.cos(phi);
                double zDir = Math.sin(phi) * Math.sin(theta);
                Vec3 direction = new Vec3(xDir, yDir, zDir).m_82541_();
                for (double d = 0.5; d <= radius; d += 0.5) {
                    Vec3 point = origin.m_82549_(direction.m_82490_(d));
                    mutablePos.m_122169_(point.f_82479_, point.f_82480_, point.f_82481_);
                    BlockState blockState = level.m_8055_((BlockPos)mutablePos);
                    Block block = blockState.m_60734_();
                    if (!EgoDeathCone.isSafeToReplace(blockState)) continue;
                    if (!EgoDeathCone.isSafeToReplace(level.m_8055_(mutablePos.m_7494_())) && !level.m_8055_(mutablePos.m_7494_()).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("zoe:death")))) {
                        level.m_46597_(mutablePos.m_7494_(), Blocks.f_50016_.m_49966_());
                    }
                    level.m_46597_((BlockPos)mutablePos, EgoDeathCone.getReplacementBlock(blockState));
                    continue block1;
                }
            }
        }
    }

    private static boolean isSafeToReplace(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("zoe:death")))) {
            return false;
        }
        if (state.m_60795_()) {
            return false;
        }
        return block != Blocks.f_50034_ && block != Blocks.f_50359_ && block != Blocks.f_50035_ && block != Blocks.f_50360_ && block != Blocks.f_50036_ && !(block instanceof FlowerBlock) && !state.m_247087_();
    }

    private static BlockState getReplacementBlock(BlockState state) {
        if (state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:logs")))) {
            return ((Block)ZoeModBlocks.DEATH_LOG.get()).m_49966_();
        }
        if (state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:leaves")))) {
            return ((Block)ZoeModBlocks.DEATH_LEAVES.get()).m_49966_();
        }
        return ((Block)ZoeModBlocks.DEATH_DIRT.get()).m_49966_();
    }
}

