/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.vami.zoe.DiasporaEmissiveLayer;
import net.vami.zoe.InsomniaEmissiveLayer;
import net.vami.zoe.RedlightEmissiveLayer;
import net.vami.zoe.SentressEmissiveLayer;
import net.vami.zoe.TyrantEmissiveLayer;
import net.vami.zoe.ZoeMod;
import net.vami.zoe.init.ZoeModEntities;

public class ClientModInitializer {
    public static void init() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientModInitializer::onClientSetup);
        modBus.addListener(ClientModInitializer::onAddLayers);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        ZoeMod.LOGGER.info("Client setup event fired");
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        List<EntityType> typesToAdd = List.of(EntityType.f_20532_, EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20562_, EntityType.f_20458_, EntityType.f_20481_, EntityType.f_20531_, EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20529_, (EntityType)ZoeModEntities.CYBORG.get());
        for (EntityType type : typesToAdd) {
            ClientModInitializer.addIfLivingEntityRenderer(event, type);
        }
        for (String skin : event.getSkins()) {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skin);
            playerRenderer.m_115326_(new DiasporaEmissiveLayer(playerRenderer));
            playerRenderer.m_115326_(new RedlightEmissiveLayer(playerRenderer));
            playerRenderer.m_115326_(new InsomniaEmissiveLayer(playerRenderer));
            playerRenderer.m_115326_(new SentressEmissiveLayer(playerRenderer));
            playerRenderer.m_115326_(new TyrantEmissiveLayer(playerRenderer));
        }
    }

    private static <T extends LivingEntity> void addIfLivingEntityRenderer(EntityRenderersEvent.AddLayers event, EntityType<T> type) {
        LivingEntityRenderer livingRenderer;
        LivingEntityRenderer renderer = event.getRenderer(type);
        if (renderer instanceof LivingEntityRenderer && (livingRenderer = renderer).m_7200_() instanceof HumanoidModel) {
            LivingEntityRenderer castRenderer = livingRenderer;
            castRenderer.m_115326_(new DiasporaEmissiveLayer(castRenderer));
            castRenderer.m_115326_(new RedlightEmissiveLayer(castRenderer));
            castRenderer.m_115326_(new InsomniaEmissiveLayer(castRenderer));
            castRenderer.m_115326_(new SentressEmissiveLayer(castRenderer));
            castRenderer.m_115326_(new TyrantEmissiveLayer(castRenderer));
        }
    }
}

