/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.configuration.ZoeConfigConfiguration;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZoeExplosion {
    public static void customExplosion(Level level, double x, double y, double z, DamageSource damageSource, float radius, float power, float dropChance, boolean isFire) {
        if (level.f_46443_ || radius <= 0.0f || power <= 0.0f) {
            return;
        }
        BlockPos origin = BlockPos.m_274561_((double)x, (double)y, (double)z);
        HashSet<BlockPos> affectedBlocks = new HashSet<BlockPos>();
        HashMap<BlockPos, BlockState> toDrop = new HashMap<BlockPos, BlockState>();
        int steps = 16;
        for (int dx = -steps; dx <= steps; ++dx) {
            for (int dy = -steps; dy <= steps; ++dy) {
                block2: for (int dz = -steps; dz <= steps; ++dz) {
                    BlockPos blockPos;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (distance > (double)radius) continue;
                    double normX = (double)dx / distance;
                    double normY = (double)dy / distance;
                    double normZ = (double)dz / distance;
                    double blastPower = power;
                    double px = x;
                    double py = y;
                    double pz = z;
                    int i = 0;
                    while ((float)i < radius * 2.0f && level.m_46749_(blockPos = BlockPos.m_274561_((double)px, (double)py, (double)pz))) {
                        BlockState blockState = level.m_8055_(blockPos);
                        FluidState fluidState = level.m_6425_(blockPos);
                        double resistance = Math.max(blockState.m_60734_().m_7325_(), fluidState.m_76190_());
                        if (!((blastPower -= resistance * (double)0.3f) > 0.0)) continue block2;
                        if (blockState.m_60734_() != Blocks.f_50016_) {
                            affectedBlocks.add(blockPos);
                            toDrop.put(blockPos, blockState);
                        }
                        px += normX;
                        py += normY;
                        pz += normZ;
                        ++i;
                    }
                }
            }
        }
        if (!((Boolean)ZoeConfigConfiguration.DISABLEEXPLOSIONGRIEF.get()).booleanValue()) {
            for (BlockPos pos : affectedBlocks) {
                BlockState state = level.m_8055_(pos);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (level.f_46441_.m_188501_() <= dropChance) {
                        Block.m_49892_((BlockState)state, (LevelAccessor)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
                    }
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        if (isFire) {
            for (BlockPos pos : affectedBlocks) {
                BlockPos below = pos.m_7495_();
                if (!level.m_8055_(pos).m_60795_() || !level.m_8055_(below).m_280296_() || !(level.f_46441_.m_188501_() < 0.3f)) continue;
                level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 11);
            }
        }
        AABB bounds = new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius);
        List entities = level.m_45933_(null, bounds);
        for (Entity entity : entities) {
            double dz;
            double dy;
            double dx;
            double distSq;
            if (entity.m_6128_() || !((distSq = (dx = entity.m_20185_() - x) * dx + (dy = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f) - y) * dy + (dz = entity.m_20189_() - z) * dz) < (double)(radius * radius))) continue;
            double distance = Math.sqrt(distSq);
            double exposure = 1.0 - distance / (double)radius;
            float damage = (float)((exposure * exposure + exposure) / 14.0 * (double)radius + 1.0);
            entity.m_6469_(damageSource, damage);
        }
        level.m_5594_(null, origin, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

