/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class ZoeConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> HUMANITYSCALING;
    public static final ForgeConfigSpec.ConfigValue<Double> MAXIMPLANTQUALITY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HARDCOREIMPLANTS;
    public static final ForgeConfigSpec.ConfigValue<Double> HARDCOREIMPLANTSCALE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DISABLEVANILLACRIT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GRAVITYFALLDAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOECRIT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOECRITSWEEP;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOECRITKBR;
    public static final ForgeConfigSpec.ConfigValue<Boolean> COLLISIONIMPACT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DISABLEARMEDVOLT;
    public static final ForgeConfigSpec.ConfigValue<Double> ZOEMAXCRITCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DISABLEEXPLOSIONGRIEF;
    public static final ForgeConfigSpec.ConfigValue<Double> VOLTMECHANICALDAMAGESCALING;
    public static final ForgeConfigSpec.ConfigValue<Double> IMPLANTDROPRATE;
    public static final ForgeConfigSpec.ConfigValue<Double> CYBORGTRAITCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> MINCYBORGTRAITS;
    public static final ForgeConfigSpec.ConfigValue<Double> MAXCYBORGTRAITS;
    public static final ForgeConfigSpec.ConfigValue<Double> RESISTANCEMECHANICALDAMAGESCALING;
    public static final ForgeConfigSpec.ConfigValue<Double> MECHANICALMOBSTATSCALING;
    public static final ForgeConfigSpec.ConfigValue<Double> PSYCHOCYBORGCHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> HELLREASSEMBLERBREAKCHANCE;

    static {
        BUILDER.push("Implants");
        HUMANITYSCALING = BUILDER.comment("Scales all implant humanity on craft (default: 1)").define("implantHumanityScaling", (Object)1.0);
        MAXIMPLANTQUALITY = BUILDER.comment("The maximum quality implants can reach. This is automatically overridden if the implant's max quality is set in its JSON config (default: 150)").define("maxImplantQuality", (Object)150.0);
        HARDCOREIMPLANTS = BUILDER.comment("If enabled, implants will lose quality upon death and break if that quality reaches 0 (default: false)").define("hardcoreImplants", false);
        HARDCOREIMPLANTSCALE = BUILDER.comment("Scales how much quality is lost on death (default: 10%)").define("hardcoreImplantDamageScaling", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("General");
        DISABLEVANILLACRIT = BUILDER.comment("Disables the vanilla jump crit (default: true)").define("disableVanillaCrit", true);
        GRAVITYFALLDAMAGE = BUILDER.comment("If true, fall damage will be reset when gravity is negative (default: true)").define("gravityFallDamage", true);
        ZOECRIT = BUILDER.comment("Enables the Zoe critical hit (default: true)").define("zoeCrit", true);
        ZOECRITSWEEP = BUILDER.comment("If enabled, crits can only be dealt on a full sweep (default: true)").define("zoeCritSweep", true);
        ZOECRITKBR = BUILDER.comment("If enabled, knockback resistance will be calculated with crit knockback (default: false)").define("zoeCritKnockback", true);
        COLLISIONIMPACT = BUILDER.comment("Allows high-speed impact with blocks to cause an explosion (unreliable)").define("collisionImpact", true);
        DISABLEARMEDVOLT = BUILDER.comment("If enabled, will prevent the Volt attribute from dealing damage if the player's hand isn't empty (default: true)").define("disableArmedVolt", true);
        ZOEMAXCRITCHANCE = BUILDER.comment("The maximum chance for a Zoe crit. Any number above this will contribute to crit damage instead (default: 100)").define("zoeMaxCritChance", (Object)100.0);
        DISABLEEXPLOSIONGRIEF = BUILDER.comment("Disables explosion griefing in some specific modded explosions").define("disableExplosionGrief", false);
        BUILDER.pop();
        BUILDER.push("Entities");
        VOLTMECHANICALDAMAGESCALING = BUILDER.comment("Scales how much extra damage mechanical mobs take from volt").define("voltMechanicalDamageScaling", (Object)1.5);
        IMPLANTDROPRATE = BUILDER.comment("The chances for a cyborg to drop an implant. Set to 0 to disable implant drops (default: 12.5)").define("implantDropRate", (Object)12.5);
        CYBORGTRAITCHANCE = BUILDER.comment("The chances of a cyborg being born with a trait. Set to 0 to disable Cyborg traits (default: 25)").define("cyborgTraitChance", (Object)25.0);
        MINCYBORGTRAITS = BUILDER.comment("The minimum amount of traits a Cyborg can have, granted it was selected to have traits (default: 1)").define("minCyborgTraits", (Object)1.0);
        MAXCYBORGTRAITS = BUILDER.comment("The maximum of traits a cyborg is allowed to have (default: 4)").define("maxCyborgTraits", (Object)4.0);
        RESISTANCEMECHANICALDAMAGESCALING = BUILDER.comment("Dictates the damage reduction to mechanical mobs of damagetypes in the mechanical_resistant_to tag (default: 0.5 = damage * 0.5)").define("resistanceMechanicalDamageScaling", (Object)0.5);
        MECHANICALMOBSTATSCALING = BUILDER.comment("Scales the stats of all mechanical mobs").define("mechanicalMobStatScaling", (Object)1.0);
        PSYCHOCYBORGCHANCE = BUILDER.comment("Adds a 1 in X (default: 15) chance for a Cyborg to spawn aggressiive").define("psychoCyborgChance", (Object)15.0);
        BUILDER.pop();
        BUILDER.push("Blocks");
        HELLREASSEMBLERBREAKCHANCE = BUILDER.comment("The chance of a Reassembler breaking when a Hell Implant is in it (default: 10)").define("hellReassemblerBreakChance", (Object)10.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

