/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.vami.zoe.procedures.GetEgoDeathInInventoryProcedure;

@Mod.EventBusSubscriber(modid="zoe", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EgoDeathTarget {
    private static boolean isHoldingEgoDeath(ServerPlayer player) {
        ItemStack mainHand = player.m_21205_();
        return mainHand.m_41720_().m_5524_().equals("item.zoe.ego_death") || EgoDeathTarget.hasEgoDeathInInventory((Player)player) && 3.0 <= GetEgoDeathInInventoryProcedure.execute((Entity)player).m_41784_().m_128459_("zEgoDeathStage");
    }

    @SubscribeEvent
    public static void onMobTargetChange(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        LivingEntity livingEntity2 = event.getNewTarget();
        if (!(livingEntity2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer targetPlayer = (ServerPlayer)livingEntity2;
        if (!EgoDeathTarget.isHoldingEgoDeath(targetPlayer)) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (mob.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("zoe:bypasses_ego")))) {
            return;
        }
        event.setCanceled(true);
        SimpleParticleType particle = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation("zoe", "ego"));
        if (particle != null) {
            level2.m_8767_((ParticleOptions)particle, mob.m_20185_(), mob.m_20186_() + (double)mob.m_20206_() + 0.5, mob.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
        }
        if (targetPlayer.m_21205_().m_41784_().m_128459_("zEgoDeathStage") >= 1.0 || GetEgoDeathInInventoryProcedure.execute((Entity)targetPlayer).m_41784_().m_128459_("zEgoDeathStage") >= 1.0) {
            List<ServerPlayer> candidates = level2.m_6907_().stream().filter(p -> !p.m_5833_() && !p.m_7500_() && !p.equals((Object)targetPlayer)).filter(p -> !EgoDeathTarget.isHoldingEgoDeath(p)).toList();
            Optional<ServerPlayer> newTarget = candidates.stream().min(Comparator.comparingDouble(p -> p.m_20280_((Entity)mob)));
            if (newTarget.isPresent()) {
                mob.m_6710_((LivingEntity)newTarget.get());
            } else {
                List nearbyMonsters = level2.m_6443_(Mob.class, mob.m_20191_().m_82400_(16.0), other -> other != mob && other.m_6084_());
                Optional<Mob> otherTarget = nearbyMonsters.stream().min(Comparator.comparingDouble(other -> other.m_20280_((Entity)mob)));
                otherTarget.ifPresent(arg_0 -> ((Mob)mob).m_6710_(arg_0));
            }
        }
    }

    private static boolean hasEgoDeathInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_41720_().m_5524_().equals("item.zoe.ego_death")) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (EgoDeathTarget.hasEgoDeathInInventory(player)) {
            event.setCanceled(true);
        }
    }
}

