/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.item.InsomniaItem;

@Mod.EventBusSubscriber(modid="zoe")
public class InsomniaInvisibility {
    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).m_20145_()) {
            boolean wearingOnlyInsomnia = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot.m_20743_() == EquipmentSlot.Type.ARMOR).map(arg_0 -> ((Player)player).m_6844_(arg_0)).allMatch(stack -> stack.m_41720_() instanceof InsomniaItem);
            if (wearingOnlyInsomnia) {
                event.modifyVisibility(0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 60 != 0) {
            return;
        }
        if (!player.m_9236_().f_46443_ && InsomniaInvisibility.isWearingFullInsomniaArmor(player) && player.m_20145_()) {
            AABB range = player.m_20191_().m_82400_(32.0);
            List mobs = player.m_9236_().m_6443_(Mob.class, range, mob -> {
                LivingEntity target = mob.m_5448_();
                return target != null && target.equals((Object)player);
            });
            for (Mob mob2 : mobs) {
                mob2.m_6710_(null);
                mob2.m_6703_(null);
                mob2.m_6598_(null);
                mob2.m_21335_(null);
                if (!(mob2 instanceof NeutralMob)) continue;
                NeutralMob neutralMob = (NeutralMob)mob2;
                neutralMob.m_6925_(null);
            }
        }
    }

    private static boolean isWearingFullInsomniaArmor(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = player.m_6844_(slot)).m_41720_() instanceof InsomniaItem) continue;
            return false;
        }
        return true;
    }
}

