/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.item.InsomniaItem;

@Mod.EventBusSubscriber(modid="zoe", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InsomniaRenderer {
    @SubscribeEvent
    public static void onRenderPlayer(RenderLivingEvent.Pre<? extends LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (InsomniaRenderer.shouldBeInvisible(player)) {
            event.setCanceled(true);
        }
    }

    private static boolean shouldBeInvisible(Player player) {
        if (!player.m_20145_()) {
            return false;
        }
        if (player.f_19802_ > 0) {
            return false;
        }
        return InsomniaRenderer.isWearingFullInsomniaArmor(player);
    }

    private static boolean isWearingFullInsomniaArmor(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() instanceof InsomniaItem && chest.m_41720_() instanceof InsomniaItem && legs.m_41720_() instanceof InsomniaItem && feet.m_41720_() instanceof InsomniaItem;
    }
}

