/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe;

import java.util.ArrayList;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.item.ScorpionItem;

@Mod.EventBusSubscriber(modid="zoe", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScorpionBackstab {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!ScorpionBackstab.isWearingFullScorpionArmor(attacker)) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (!ScorpionBackstab.isBehindTarget(attacker, target)) {
            return;
        }
        float originalDamage = event.getAmount();
        event.setAmount(originalDamage * 1.5f);
    }

    @SubscribeEvent
    public static void potionDamageCancel(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!ScorpionBackstab.isWearingFullScorpionArmor(player)) {
            return;
        }
        String id = event.getSource().m_19385_();
        if (event.getSource().m_7640_() instanceof ThrownPotion || event.getSource().m_7640_() instanceof AreaEffectCloud || id.equals("magic") || id.equals("indirect_magic") || id.equals("wither")) {
            event.setCanceled(true);
        }
    }

    private static boolean isWearingFullScorpionArmor(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            Item item;
            if (!slot.m_254934_() || (item = (stack = player.m_6844_(slot)).m_41720_()) instanceof ScorpionItem) continue;
            return false;
        }
        return true;
    }

    private static boolean isBehindTarget(Player attacker, LivingEntity target) {
        Vec3 targetLook;
        Vec3 toAttacker = attacker.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        double dot = toAttacker.m_82526_(targetLook = target.m_20154_().m_82541_());
        return dot < -0.5;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!ScorpionBackstab.isWearingFullScorpionArmor(player)) {
            return;
        }
        for (MobEffectInstance effect : new ArrayList(player.m_21220_())) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            player.m_21195_(effect.m_19544_());
        }
    }

    private static boolean isNegativeEffect(MobEffectInstance effect) {
        return effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL;
    }
}

