/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.vami.zoe.init.ZoeModEntities;
import net.vami.zoe.procedures.FyberEntityIsHurtProcedure;
import net.vami.zoe.procedures.FyberNaturalEntitySpawningConditionProcedure;
import net.vami.zoe.procedures.FyberOnEntityTickUpdateProcedure;
import net.vami.zoe.procedures.FyberSizeReturnProcedure;

public class FyberEntity
extends Monster {
    public static final EntityDataAccessor<String> DATA_color = SynchedEntityData.m_135353_(FyberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public FyberEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FyberEntity>)((EntityType)ZoeModEntities.FYBER.get()), world);
    }

    public FyberEntity(EntityType<FyberEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 8;
        this.m_21557_(false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (FyberEntity.this.m_20069_()) {
                    FyberEntity.this.m_20256_(FyberEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !FyberEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - FyberEntity.this.m_20185_();
                    double dy = this.f_24976_ - FyberEntity.this.m_20186_();
                    double dz = this.f_24977_ - FyberEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * FyberEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    FyberEntity.this.m_146922_(this.m_24991_(FyberEntity.this.m_146908_(), f, 10.0f));
                    FyberEntity.this.f_20883_ = FyberEntity.this.m_146908_();
                    FyberEntity.this.f_20885_ = FyberEntity.this.m_146908_();
                    if (FyberEntity.this.m_20069_()) {
                        FyberEntity.this.m_7910_((float)FyberEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        FyberEntity.this.m_146926_(this.m_24991_(FyberEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(FyberEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        FyberEntity.this.m_21564_(f3 * f1);
                        FyberEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        FyberEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    FyberEntity.this.m_7910_(0.0f);
                    FyberEntity.this.m_21567_(0.0f);
                    FyberEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_color, (Object)"blue");
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zoe:cyborg_hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zoe:cyborg_death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        FyberEntity entity = this;
        Entity sourceentity = damagesource.m_7639_();
        Entity immediatesourceentity = damagesource.m_7640_();
        if (!FyberEntityIsHurtProcedure.execute(damagesource)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Datacolor", (String)this.f_19804_.m_135370_(DATA_color));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Datacolor")) {
            this.f_19804_.m_135381_(DATA_color, (Object)compound.m_128461_("Datacolor"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        FyberOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        this.m_6210_();
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6040_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        FyberEntity entity = this;
        return true;
    }

    public boolean m_6063_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        FyberEntity entity = this;
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        FyberEntity entity = this;
        Level world = this.m_9236_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        return super.m_6972_(pose).m_20388_((float)FyberSizeReturnProcedure.execute());
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ZoeModEntities.FYBER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return FyberNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3);
        return builder;
    }
}

