/*
 * Decompiled with CFR 0.152.
 */
package net.vami.zoe.procedures;

import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vami.zoe.configuration.ZoeConfigConfiguration;
import net.vami.zoe.procedures.IsSolidBlockCheckProcedure;
import net.vami.zoe.procedures.PlayerSpeedReturnProcedure;

@Mod.EventBusSubscriber
public class ExplodeOnHitBlockProcedure {
    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        ExplodeOnHitBlockProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20189_(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double z, Entity entity) {
        ExplodeOnHitBlockProcedure.execute(null, world, x, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        Entity lastAttacker = null;
        double currentSpeed = 0.0;
        double speedSubtract = 0.0;
        double posZ = 0.0;
        double posY = 0.0;
        double posX = 0.0;
        if (!world.m_5776_() && ((Boolean)ZoeConfigConfiguration.COLLISIONIMPACT.get()).booleanValue() && entity.getPersistentData().m_128471_("zCanImpact")) {
            speedSubtract = PlayerSpeedReturnProcedure.execute(entity);
            AABB inflatedBox = entity.m_20191_().m_82400_(0.05);
            BlockPos min = new BlockPos((int)Math.floor(inflatedBox.f_82288_), (int)Math.floor(inflatedBox.f_82289_ + 0.05), (int)Math.floor(inflatedBox.f_82290_));
            BlockPos max = new BlockPos((int)Math.floor(inflatedBox.f_82291_), (int)Math.floor(inflatedBox.f_82292_), (int)Math.floor(inflatedBox.f_82293_));
            BlockPos hitPos = null;
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)min, (BlockPos)max).map(BlockPos::m_7949_).toList()) {
                boolean intersects;
                BlockState state = world.m_8055_(pos);
                VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
                if (shape.m_83281_() || !(intersects = shape.m_83215_().m_82338_(pos).m_82381_(inflatedBox)) && !IsSolidBlockCheckProcedure.execute(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) continue;
                hitPos = pos;
                break;
            }
            if (hitPos != null) {
                Level _level;
                lastAttacker = new BiFunction<LevelAccessor, String, Entity>(){

                    @Override
                    public Entity apply(LevelAccessor levelAccessor, String uuid) {
                        if (levelAccessor instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)levelAccessor;
                            try {
                                return serverLevel.m_8791_(UUID.fromString(uuid));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }.apply(world, entity.getPersistentData().m_128461_("zLastAttacker"));
                if (speedSubtract >= 0.7 && lastAttacker != null && world instanceof Level && !(_level = (Level)world).m_5776_()) {
                    _level.m_254877_(lastAttacker, new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268576_)), null, ((double)hitPos.m_123341_() + x) / 2.0, (double)hitPos.m_123342_(), ((double)hitPos.m_123343_() + z) / 2.0, (float)Math.max(1.0, speedSubtract / 2.5), false, Level.ExplosionInteraction.MOB);
                }
                entity.getPersistentData().m_128379_("zCanImpact", false);
            }
            if (speedSubtract == 0.0) {
                entity.getPersistentData().m_128379_("zCanImpact", false);
            }
        }
    }
}

