/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation.categories;

import com.ssomar.aichatmoderation.actions.Action;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class Category {
    private String id;
    private boolean detection;
    private Map<String, Action> actions;

    public Category(ConfigurationSection config) {
        this.id = config.getName();
        this.detection = config.getBoolean("detection", true);
        this.actions = new LinkedHashMap<String, Action>();
        if (config.contains("actions")) {
            ConfigurationSection actionsSection = config.getConfigurationSection("actions");
            for (String actionId : actionsSection.getKeys(false)) {
                ConfigurationSection actionSection = actionsSection.getConfigurationSection(actionId);
                Action action = new Action(actionSection);
                this.actions.put(actionId, action);
            }
            this.actions = this.getSortedActionsByConfidenceDesc();
        }
    }

    public Map<String, Action> getSortedActionsByConfidenceDesc() {
        ArrayList<Map.Entry<String, Action>> entryList = new ArrayList<Map.Entry<String, Action>>(this.actions.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Action>>(){

            @Override
            public int compare(Map.Entry<String, Action> entry1, Map.Entry<String, Action> entry2) {
                return Double.compare(entry2.getValue().getConfidence(), entry1.getValue().getConfidence());
            }
        });
        LinkedHashMap<String, Action> sortedMap = new LinkedHashMap<String, Action>();
        for (Map.Entry entry : entryList) {
            sortedMap.put((String)entry.getKey(), (Action)entry.getValue());
        }
        return sortedMap;
    }

    @Nullable
    public Action getAction(double confidence) {
        for (Action action : this.actions.values()) {
            if (!(action.getConfidence() <= confidence)) continue;
            return action;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public boolean isDetection() {
        return this.detection;
    }

    public Map<String, Action> getActions() {
        return this.actions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDetection(boolean detection) {
        this.detection = detection;
    }

    public void setActions(Map<String, Action> actions) {
        this.actions = actions;
    }
}

