/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation;

import com.ssomar.aichatmoderation.bukkit.Metrics;
import com.ssomar.aichatmoderation.categories.Category;
import com.ssomar.aichatmoderation.commands.ACMCommands;
import com.ssomar.aichatmoderation.listeners.OnChatListener;
import com.ssomar.aichatmoderation.scheduler.BukkitSchedulerHook;
import com.ssomar.aichatmoderation.scheduler.RegionisedSchedulerHook;
import com.ssomar.aichatmoderation.scheduler.SchedulerHook;
import com.ssomar.aichatmoderation.utils.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AIChatModeration
extends JavaPlugin {
    public static AIChatModeration plugin;
    public static SchedulerHook schedulerHook;
    private boolean configEnabled = true;
    private boolean logsFlaggedMessages = true;
    private String loggedMessageFormat = "";
    private boolean printAPIErrors = false;
    private boolean checkAfterMessageHasBeenSent;
    private Map<String, Category> categories = new HashMap<String, Category>();
    private List<String> providers = new ArrayList<String>();
    private List<String> blackListedWords = new ArrayList<String>();
    private boolean blacklistedWordsHideMessage = true;
    private List<String> blacklistedWordsCommands = new ArrayList<String>();
    private String sendFlaggedMessagesToPlayersWithPermission = "";
    public static boolean isFolia;

    public void onEnable() {
        plugin = this;
        int pluginId = 25300;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("Version of the server: " + Bukkit.getServer().getVersion());
        isFolia = AIChatModeration.hasClass("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
        if (isFolia) {
            this.getLogger().info("Detected Folia server. Using RegionisedSchedulerHook.");
        }
        schedulerHook = isFolia ? new RegionisedSchedulerHook((Plugin)plugin) : new BukkitSchedulerHook((Plugin)plugin);
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("acm").setExecutor((CommandExecutor)new ACMCommands(this));
        this.getServer().getPluginManager().registerEvents((Listener)new OnChatListener(this), (Plugin)this);
        this.getLogger().info("AI Minecraft Plugin enabled! (by Ssomar)");
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onDisable() {
        this.getLogger().info("AI Minecraft Plugin disabled! (by Ssomar)");
    }

    public void loadConfig() {
        this.reloadConfig();
        this.configEnabled = this.getConfig().getBoolean("enabled", true);
        this.logsFlaggedMessages = this.getConfig().getBoolean("logs-flagged-messages", true);
        this.loggedMessageFormat = this.getConfig().getString("logged-message-format", "Flagged message: Player:[%player%] - Message:[%message%] - Category:[%category%] - Confidence[%confidence%]");
        this.printAPIErrors = this.getConfig().getBoolean("print-api-errors", false);
        this.checkAfterMessageHasBeenSent = this.getConfig().getBoolean("check-after-message-has-been-sent", false);
        if (this.getConfig().contains("categories")) {
            for (String key : this.getConfig().getConfigurationSection("categories").getKeys(false)) {
                ConfigurationSection categorySection = this.getConfig().getConfigurationSection("categories." + key);
                Category category = new Category(categorySection);
                this.categories.put(key, category);
            }
        }
        this.providers = new ArrayList<String>();
        if (this.getConfig().contains("provider")) {
            String provider = this.getConfig().getString("provider");
            if (provider != null) {
                this.providers.add(provider);
            }
        } else {
            this.providers = this.getConfig().getStringList("providers");
        }
        if (this.getConfig().contains("blacklisted-words")) {
            this.blackListedWords = this.getConfig().getStringList("blacklisted-words");
            this.blackListedWords.replaceAll(String::toLowerCase);
        } else {
            this.getLogger().warning("No blacklisted words found in the config. You can add some if you want (blacklisted-words).");
        }
        this.blacklistedWordsHideMessage = this.getConfig().getBoolean("blacklisted-words-hide-message", true);
        if (this.getConfig().contains("blacklisted-words-commands")) {
            this.blacklistedWordsCommands = this.getConfig().getStringList("blacklisted-words-commands");
        }
        for (int i = 0; i < this.blacklistedWordsCommands.size(); ++i) {
            String cmd = this.blacklistedWordsCommands.get(i);
            String coloredCmd = StringConverter.coloredString(cmd);
            this.blacklistedWordsCommands.set(i, coloredCmd);
        }
        this.sendFlaggedMessagesToPlayersWithPermission = this.getConfig().getString("send-flagged-messages-to-players-with-permission", "");
    }

    public boolean isConfigEnabled() {
        return this.configEnabled;
    }

    public boolean isLogsFlaggedMessages() {
        return this.logsFlaggedMessages;
    }

    public String getLoggedMessageFormat() {
        return this.loggedMessageFormat;
    }

    public boolean isPrintAPIErrors() {
        return this.printAPIErrors;
    }

    public boolean isCheckAfterMessageHasBeenSent() {
        return this.checkAfterMessageHasBeenSent;
    }

    public Map<String, Category> getCategories() {
        return this.categories;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public List<String> getBlackListedWords() {
        return this.blackListedWords;
    }

    public boolean isBlacklistedWordsHideMessage() {
        return this.blacklistedWordsHideMessage;
    }

    public List<String> getBlacklistedWordsCommands() {
        return this.blacklistedWordsCommands;
    }

    public String getSendFlaggedMessagesToPlayersWithPermission() {
        return this.sendFlaggedMessagesToPlayersWithPermission;
    }
}

