/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation.actions;

import com.ssomar.aichatmoderation.AIChatModeration;
import com.ssomar.aichatmoderation.utils.StringConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Action {
    private String id;
    private double confidence;
    private boolean hideMessage;
    private List<String> commands;

    public Action() {
        this.id = "default";
        this.confidence = 1.0;
        this.hideMessage = true;
        this.commands = new ArrayList<String>();
    }

    public Action(ConfigurationSection section) {
        this.id = section.getName();
        this.confidence = section.getDouble("confidence", 0.85);
        this.hideMessage = section.getBoolean("hideMessage", true);
        this.commands = section.getStringList("commands");
        for (int i = 0; i < this.commands.size(); ++i) {
            this.commands.set(i, StringConverter.coloredString(this.commands.get(i)));
        }
    }

    public void runCommands(final @NotNull Player player) {
        final ConsoleCommandSender console = Bukkit.getConsoleSender();
        BukkitRunnable runnable = new BukkitRunnable(this){
            final /* synthetic */ Action this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                for (String command : this.this$0.commands) {
                    command = command.replace("%player%", player.getName());
                    if ((command = command.replace("%player_uuid%", player.getUniqueId().toString())).startsWith("SEND_MESSAGE")) {
                        command = command.replace("SEND_MESSAGE", "");
                        player.sendMessage(command);
                        continue;
                    }
                    Bukkit.dispatchCommand((CommandSender)console, (String)command);
                }
            }
        };
        AIChatModeration.schedulerHook.runEntityTask((Runnable)runnable, null, (Entity)player, 0L);
    }

    public String getId() {
        return this.id;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public boolean isHideMessage() {
        return this.hideMessage;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public void setHideMessage(boolean hideMessage) {
        this.hideMessage = hideMessage;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }
}

