/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation.commands;

import com.ssomar.aichatmoderation.AIChatModeration;
import com.ssomar.aichatmoderation.listeners.DebugManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ACMCommands
implements CommandExecutor,
TabExecutor {
    private final AIChatModeration plugin;

    public ACMCommands(AIChatModeration plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /acm reload | debug");
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("acm.reload")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            this.plugin.loadConfig();
            sender.sendMessage("\u00a7aConfig reloaded.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("debug")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by a player.");
                return true;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission("acm.debug")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            List<UUID> players = DebugManager.getInstance().getDebugPlayers();
            if (players.contains(player.getUniqueId())) {
                players.remove(player.getUniqueId());
                sender.sendMessage("\u00a7cYou are no longer in debug mode.");
            } else {
                players.add(player.getUniqueId());
                sender.sendMessage("\u00a7aYou are now in debug mode.");
            }
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase("acm") && args.length == 1) {
            return Arrays.asList("reload", "debug");
        }
        return Collections.emptyList();
    }
}

