/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation.listeners;

import com.ssomar.aichatmoderation.AIChatModeration;
import com.ssomar.aichatmoderation.actions.Action;
import com.ssomar.aichatmoderation.categories.Category;
import com.ssomar.aichatmoderation.listeners.DebugManager;
import com.ssomar.aichatmoderation.utils.StringConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class OnChatListener
implements Listener {
    private AIChatModeration plugin;
    private final JSONParser jsonParser = new JSONParser();

    public OnChatListener(AIChatModeration plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAsyncPlayerChatEvent(final AsyncPlayerChatEvent e) {
        Player player;
        if (this.plugin.isConfigEnabled() && !(player = e.getPlayer()).hasPermission("acm.bypass")) {
            if (this.plugin.isCheckAfterMessageHasBeenSent()) {
                BukkitRunnable runnable = new BukkitRunnable(this){
                    final /* synthetic */ OnChatListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        this.this$0.checkMessage(e);
                    }
                };
                AIChatModeration.schedulerHook.runEntityTask((Runnable)runnable, null, (Entity)player, 0L);
            } else {
                this.checkMessage(e);
            }
        }
    }

    private void checkMessage(AsyncPlayerChatEvent e) {
        String message = e.getMessage();
        String uncoloredMessage = StringConverter.decoloredString(message);
        List<String> blackListedWords = this.plugin.getBlackListedWords();
        if (!blackListedWords.isEmpty()) {
            String uncoloredMessageLower = uncoloredMessage.toLowerCase();
            for (String blackListedWord : blackListedWords) {
                if (!uncoloredMessageLower.contains(blackListedWord)) continue;
                if (this.plugin.isBlacklistedWordsHideMessage()) {
                    e.setCancelled(true);
                }
                Action action = new Action();
                action.setCommands(this.plugin.getBlacklistedWordsCommands());
                action.runCommands(e.getPlayer());
                this.sendDebugMessage("&7&oDebug Message: \n&cMessage contains blacklisted word: " + blackListedWord);
                return;
            }
        }
        for (String provider : this.plugin.getProviders()) {
            try {
                URL url = new URL("https://api.ssomar.com/api/moderation");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("x-api-key", "no-key");
                conn.setRequestProperty("provider", provider);
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(500);
                conn.setDoOutput(true);
                String jsonInputString = "{\"input\": \"" + uncoloredMessage.replace("\"", "\\\"") + "\"}";
                try (OutputStream os = conn.getOutputStream();){
                    os.write(jsonInputString.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                }
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String response = this.readInputStream(conn.getInputStream());
                    JSONObject jsonResponse = (JSONObject)this.jsonParser.parse(response);
                    if (!this.processModerationResult(jsonResponse, e)) continue;
                    break;
                }
                this.sendDebugMessage("&7&oDebug Message: \n&cModeration API returned an error: " + responseCode);
            }
            catch (Exception ex) {
                if (!this.plugin.isPrintAPIErrors()) continue;
                ex.printStackTrace();
            }
        }
    }

    private boolean processModerationResult(JSONObject jsonResponse, final AsyncPlayerChatEvent e) {
        block19: {
            try {
                JSONObject categoriesFlagged = (JSONObject)jsonResponse.get((Object)"categoriesFlagged");
                JSONObject categoriesConfidence = (JSONObject)jsonResponse.get((Object)"categoriesConfidence");
                Map<String, Category> categories = this.plugin.getCategories();
                for (Object key : categoriesConfidence.keySet()) {
                    double confidence;
                    Category categoryObj;
                    Action action;
                    String category = (String)key;
                    if (!categories.containsKey(category) || !categories.get(category).isDetection() || (action = (categoryObj = categories.get(category)).getAction(confidence = ((Double)categoriesConfidence.getOrDefault((Object)category, (Object)0.0)).doubleValue())) == null) continue;
                    if (this.plugin.isLogsFlaggedMessages()) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        String formattedDate = LocalDateTime.now().format(formatter);
                        String logMessage = this.plugin.getLoggedMessageFormat().replace("%time%", formattedDate).replace("%player%", e.getPlayer().getName()).replace("%message%", e.getMessage()).replace("%category%", category).replace("%confidence%", String.valueOf(confidence));
                        this.plugin.getLogger().info(logMessage);
                        File pluginFolder = this.plugin.getDataFolder();
                        File logFile = new File(pluginFolder, "logs.txt");
                        if (!logFile.exists()) {
                            logFile.createNewFile();
                        }
                        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));){
                            writer.write(logMessage);
                            writer.newLine();
                        }
                        catch (IOException ex) {
                            this.plugin.getLogger().warning("Failed to write to log file: " + ex.getMessage());
                        }
                        if (!this.plugin.getSendFlaggedMessagesToPlayersWithPermission().isEmpty()) {
                            try {
                                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                                    if (!player.hasPermission(this.plugin.getSendFlaggedMessagesToPlayersWithPermission())) continue;
                                    player.sendMessage(StringConverter.coloredString(logMessage));
                                }
                            }
                            catch (Error | Exception throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (action.isHideMessage()) {
                        e.setCancelled(true);
                    }
                    BukkitRunnable runnable = new BukkitRunnable(this){
                        final /* synthetic */ OnChatListener this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            action.runCommands(e.getPlayer());
                        }
                    };
                    AIChatModeration.schedulerHook.runEntityTask((Runnable)runnable, null, (Entity)e.getPlayer(), 0L);
                    return true;
                }
                this.sendDebugMessage(categoriesFlagged, categoriesConfidence);
            }
            catch (Exception ex) {
                if (this.plugin.isPrintAPIErrors()) {
                    System.err.println("Error processing moderation result: " + ex.getMessage());
                }
                if (!this.plugin.isPrintAPIErrors()) break block19;
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void sendDebugMessage(JSONObject categoriesFlagged, JSONObject categoriesConfidence) {
        StringBuilder message = new StringBuilder();
        message.append("&7&oDebug Message: \n");
        message.append("&7&oCategories: \n");
        for (Object key : categoriesConfidence.keySet()) {
            String category = (String)key;
            double confidence = (Double)categoriesConfidence.getOrDefault((Object)category, (Object)0.0);
            message.append("&7&o- &e").append(category).append(" &7&oConfidence: &e").append(confidence).append("\n");
        }
        String messageStr = StringConverter.coloredString(message.toString());
        this.sendDebugMessage(messageStr);
    }

    public void sendDebugMessage(final String message) {
        BukkitRunnable runnable = new BukkitRunnable(this){
            final /* synthetic */ OnChatListener this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                List<Player> players = DebugManager.getInstance().getDebugOnlinePlayers();
                if (players.isEmpty()) {
                    return;
                }
                for (Player player : DebugManager.getInstance().getDebugOnlinePlayers()) {
                    if (player == null || !player.isOnline()) continue;
                    player.sendMessage(StringConverter.coloredString(message));
                }
            }
        };
        AIChatModeration.schedulerHook.runAsyncTask((Runnable)runnable, 1L);
    }

    private String readInputStream(InputStream is) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

